/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.moead.MOEAD;
import jmetal.metaheuristics.moead.pMOEAD;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class MOEAD_Settings
extends Settings {
    public double CR_;
    public double F_;
    public int populationSize_;
    public int maxEvaluations_;
    public double mutationProbability_;
    public double distributionIndexForMutation_;
    public String dataDirectory_;
    public int numberOfThreads;
    public String moeadVersion;

    public MOEAD_Settings(String problem) {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.CR_ = 1.0;
        this.F_ = 0.5;
        this.populationSize_ = 300;
        this.maxEvaluations_ = 150000;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
        this.distributionIndexForMutation_ = 20.0;
        this.dataDirectory_ = "/Users/antonio/Softw/pruebas/data/MOEAD_parameters/Weight";
        this.numberOfThreads = 2;
        this.moeadVersion = "MOEAD";
    }

    @Override
    public Algorithm configure() throws JMException {
        Algorithm algorithm;
        if (this.moeadVersion.compareTo("MOEAD") == 0) {
            algorithm = new MOEAD(this.problem_);
        } else {
            algorithm = new pMOEAD(this.problem_);
            algorithm.setInputParameter("numberOfThreads", this.numberOfThreads);
        }
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("dataDirectory", this.dataDirectory_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("CR", this.CR_);
        parameters.put("F", this.F_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("DifferentialEvolutionCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", 1.0 / (double)this.problem_.getNumberOfVariables());
        parameters.put("distributionIndex", this.distributionIndexForMutation_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        return algorithm;
    }
}

