/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.nsgaII.NSGAII;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class NSGAIIBinary_Settings
extends Settings {
    int populationSize_;
    int maxEvaluations_;
    double mutationProbability_;
    double crossoverProbability_;

    public NSGAIIBinary_Settings(String problem) {
        super(problem);
        Object[] problemParams = new Object[]{"Binary"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.populationSize_ = 100;
        this.maxEvaluations_ = 25000;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfBits();
        this.crossoverProbability_ = 0.9;
    }

    @Override
    public Algorithm configure() throws JMException {
        NSGAII algorithm = new NSGAII(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.crossoverProbability_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SinglePointCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        Mutation mutation = MutationFactory.getMutationOperator("BitFlipMutation", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("BinaryTournament2", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }
}

