/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.omopso.OMOPSO;
import jmetal.operators.mutation.NonUniformMutation;
import jmetal.operators.mutation.UniformMutation;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class OMOPSO_Settings
extends Settings {
    public int swarmSize_;
    public int maxIterations_;
    public int archiveSize_;
    public double perturbationIndex_;

    public OMOPSO_Settings(String problem) {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.swarmSize_ = 100;
        this.maxIterations_ = 250;
        this.archiveSize_ = 100;
        this.perturbationIndex_ = 0.5;
    }

    @Override
    public Algorithm configure() throws JMException {
        OMOPSO algorithm = new OMOPSO(this.problem_);
        Integer maxIterations = 250;
        Double perturbationIndex = 0.5;
        Double mutationProbability = 1.0 / (double)this.problem_.getNumberOfVariables();
        algorithm.setInputParameter("swarmSize", this.swarmSize_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        algorithm.setInputParameter("maxIterations", this.maxIterations_);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", mutationProbability);
        parameters.put("perturbation", perturbationIndex);
        UniformMutation uniformMutation = new UniformMutation(parameters);
        parameters = new HashMap();
        parameters.put("probability", mutationProbability);
        parameters.put("perturbation", perturbationIndex);
        parameters.put("maxIterations", maxIterations);
        NonUniformMutation nonUniformMutation = new NonUniformMutation(parameters);
        algorithm.addOperator("uniformMutation", uniformMutation);
        algorithm.addOperator("nonUniformMutation", nonUniformMutation);
        return algorithm;
    }
}

