/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.paes.PAES;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class PAES_Settings
extends Settings {
    public int maxEvaluations_;
    public int archiveSize_;
    public int biSections_;
    public double mutationProbability_;
    public double distributionIndex_;

    public PAES_Settings(String problem) {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.maxEvaluations_ = 25000;
        this.archiveSize_ = 100;
        this.biSections_ = 5;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
        this.distributionIndex_ = 20.0;
    }

    @Override
    public Algorithm configure() throws JMException {
        PAES algorithm = new PAES(this.problem_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("biSections", this.biSections_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.distributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("mutation", mutation);
        return algorithm;
    }
}

