/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.smpso.SMPSO;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class SMPSO_Settings
extends Settings {
    public int swarmSize_;
    public int maxIterations_;
    public int archiveSize_;
    public double mutationDistributionIndex_;
    public double mutationProbability_;

    public SMPSO_Settings(String problem) {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.swarmSize_ = 100;
        this.maxIterations_ = 250;
        this.archiveSize_ = 100;
        this.mutationDistributionIndex_ = 20.0;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
    }

    @Override
    public Algorithm configure() throws JMException {
        SMPSO algorithm = new SMPSO(this.problem_);
        algorithm.setInputParameter("swarmSize", this.swarmSize_);
        algorithm.setInputParameter("maxIterations", this.maxIterations_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("mutation", mutation);
        return algorithm;
    }
}

