/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.smsemoa.SMSEMOA;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class SMSEMOA_Settings
extends Settings {
    public int populationSize_;
    public int maxEvaluations_;
    public double mutationProbability_;
    public double crossoverProbability_;
    public double crossoverDistributionIndex_;
    public double mutationDistributionIndex_;
    public double offset_;

    public SMSEMOA_Settings(String problem) throws JMException {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.populationSize_ = 100;
        this.maxEvaluations_ = 25000;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
        this.crossoverProbability_ = 0.9;
        this.crossoverDistributionIndex_ = 20.0;
        this.mutationDistributionIndex_ = 20.0;
        this.offset_ = 100.0;
    }

    @Override
    public Algorithm configure() throws JMException {
        SMSEMOA algorithm = new SMSEMOA(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("offset", this.offset_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", this.crossoverProbability_);
        parameters.put("distributionIndex", this.crossoverDistributionIndex_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SBXCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("RandomSelection", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }
}

