/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import jmetal.experiments.Experiment;
import jmetal.experiments.util.Pareja;

public class Friedman {
    Experiment exp_;

    public Friedman(Experiment exp) {
        this.exp_ = exp;
    }

    public void executeFriedmanTest(String indic) {
        String cadena = "";
        double sumatoria = 0.0;
        String indicator_ = indic;
        String outDir = this.exp_.experimentBaseDirectory_ + "/latex";
        String outFile = outDir + "/FriedmanTest" + indicator_ + ".tex";
        String Output = new String();
        Output = Output + "\\documentclass{article}\n\\usepackage{graphicx}\n\\title{Results}\n\\author{}\n\\date{\\today}\n\\begin{document}\n\\oddsidemargin 0in \\topmargin 0in\\maketitle\n\\section{Tables of Friedman Tests}";
        for (int prob = 0; prob < this.exp_.problemList_.length; ++prob) {
            int k;
            int j;
            int i;
            Vector<String> algoritmos = new Vector<String>();
            Vector<String> datasets = new Vector<String>();
            Vector datos = new Vector();
            for (int alg = 0; alg < this.exp_.algorithmNameList_.length; ++alg) {
                algoritmos.add(new String(this.exp_.algorithmNameList_[alg]));
                datos.add(new Vector());
                String ruta = this.exp_.experimentBaseDirectory_ + "/data/" + this.exp_.algorithmNameList_[alg] + "/" + this.exp_.problemList_[prob] + "/" + indicator_;
                cadena = "";
                try {
                    FileInputStream fis = new FileInputStream(ruta);
                    byte[] leido = new byte[4096];
                    int bytesLeidos = 0;
                    while (bytesLeidos != -1) {
                        bytesLeidos = fis.read(leido);
                        if (bytesLeidos == -1) continue;
                        cadena = cadena + new String(leido, 0, bytesLeidos);
                    }
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
                StringTokenizer lineas = new StringTokenizer(cadena, "\n\r");
                int fila = 1;
                while (lineas.hasMoreTokens()) {
                    if (alg == 0) {
                        datasets.add(new String("" + fila));
                    }
                    String linea = lineas.nextToken();
                    ((Vector)datos.elementAt(alg)).add(new Double(linea));
                    ++fila;
                }
            }
            double[][] mean = new double[datasets.size()][algoritmos.size()];
            for (i = 0; i < datasets.size(); ++i) {
                for (j = 0; j < algoritmos.size(); ++j) {
                    mean[i][j] = (Double)((Vector)datos.elementAt(j)).elementAt(i);
                }
            }
            Pareja[][] orden = new Pareja[datasets.size()][algoritmos.size()];
            for (i = 0; i < datasets.size(); ++i) {
                for (j = 0; j < algoritmos.size(); ++j) {
                    orden[i][j] = new Pareja(j, mean[i][j]);
                }
                Arrays.sort(orden[i]);
            }
            Pareja[][] rank = new Pareja[datasets.size()][algoritmos.size()];
            int posicion = 0;
            for (i = 0; i < datasets.size(); ++i) {
                for (j = 0; j < algoritmos.size(); ++j) {
                    boolean encontrado = false;
                    for (k = 0; k < algoritmos.size() && !encontrado; ++k) {
                        if (orden[i][k].indice != (double)j) continue;
                        encontrado = true;
                        posicion = k + 1;
                    }
                    rank[i][j] = new Pareja(posicion, orden[i][posicion - 1].valor);
                }
            }
            for (i = 0; i < datasets.size(); ++i) {
                boolean[] visto = new boolean[algoritmos.size()];
                Vector<Integer> porVisitar = new Vector<Integer>();
                Arrays.fill(visto, false);
                for (j = 0; j < algoritmos.size(); ++j) {
                    porVisitar.removeAllElements();
                    double sum = rank[i][j].indice;
                    visto[j] = true;
                    int ig = 1;
                    for (k = j + 1; k < algoritmos.size(); ++k) {
                        if (rank[i][j].valor != rank[i][k].valor || visto[k]) continue;
                        sum += rank[i][k].indice;
                        ++ig;
                        porVisitar.add(new Integer(k));
                        visto[k] = true;
                    }
                    rank[i][j].indice = sum /= (double)ig;
                    for (k = 0; k < porVisitar.size(); ++k) {
                        rank[i][((Integer)porVisitar.elementAt((int)k)).intValue()].indice = sum;
                    }
                }
            }
            double[] Rj = new double[algoritmos.size()];
            for (i = 0; i < algoritmos.size(); ++i) {
                Rj[i] = 0.0;
                for (j = 0; j < datasets.size(); ++j) {
                    int n = i;
                    Rj[n] = Rj[n] + rank[j][i].indice / (double)datasets.size();
                }
            }
            Output = Output + "\n" + "\\begin{table}[!htp]\n\\centering\n\\caption{Average Rankings of the algorithms for " + this.exp_.problemList_[prob] + " problem\n}" + "\\begin{tabular}{c|c}\n" + "Algorithm&Ranking\\\\\n\\hline";
            for (i = 0; i < algoritmos.size(); ++i) {
                Output = Output + "\n" + (String)algoritmos.elementAt(i) + "&" + Rj[i] + "\\\\";
            }
            Output = Output + "\n" + "\\end{tabular}\n" + "\\end{table}";
            double termino1 = 12.0 * (double)datasets.size() / ((double)algoritmos.size() * ((double)algoritmos.size() + 1.0));
            double termino2 = (double)algoritmos.size() * ((double)algoritmos.size() + 1.0) * ((double)algoritmos.size() + 1.0) / 4.0;
            for (i = 0; i < algoritmos.size(); ++i) {
                sumatoria += Rj[i] * Rj[i];
            }
            double friedman = (sumatoria - termino2) * termino1;
            Output = Output + "\n" + "\n\nFriedman statistic considering reduction performance (distributed according to chi-square with " + (algoritmos.size() - 1) + " degrees of freedom: " + friedman + ").\n\n";
        }
        Output = Output + "\n" + "\\end{document}";
        try {
            File latexOutput = new File(outDir);
            if (!latexOutput.exists()) {
                latexOutput.mkdirs();
            }
            FileOutputStream f = new FileOutputStream(outFile);
            DataOutputStream fis = new DataOutputStream(f);
            fis.writeBytes(Output);
            fis.close();
            f.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

