/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.util;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.Problem;
import jmetal.core.SolutionSet;
import jmetal.experiments.Experiment;
import jmetal.experiments.Settings;
import jmetal.util.JMException;

public class RunExperiment
extends Thread {
    public Experiment experiment_;
    public int id_;
    public HashMap<String, Object> map_;
    public int numberOfThreads_;
    public int numberOfProblems_;
    static boolean finished;
    String experimentName_;
    String[] algorithmNameList_;
    String[] problemList_;
    String[] paretoFrontFile_;
    String[] indicatorList_;
    String experimentBaseDirectory_;
    String latexDirectory_;
    String rDirectory_;
    String paretoFrontDirectory_;
    String outputParetoFrontFile_;
    String outputParetoSetFile_;
    int independentRuns_;
    Settings[] algorithmSettings_;

    public RunExperiment(Experiment experiment, HashMap<String, Object> map, int id, int numberOfThreads, int numberOfProblems) {
        this.experiment_ = experiment;
        this.id_ = id;
        this.map_ = map;
        this.numberOfThreads_ = numberOfThreads;
        this.numberOfProblems_ = numberOfProblems;
        finished = false;
    }

    @Override
    public void run() {
        String experimentName = (String)this.map_.get("experimentName");
        this.experimentBaseDirectory_ = (String)this.map_.get("experimentDirectory");
        this.algorithmNameList_ = (String[])this.map_.get("algorithmNameList");
        this.problemList_ = (String[])this.map_.get("problemList");
        this.indicatorList_ = (String[])this.map_.get("indicatorList");
        this.paretoFrontDirectory_ = (String)this.map_.get("paretoFrontDirectory");
        this.paretoFrontFile_ = (String[])this.map_.get("paretoFrontFile");
        this.independentRuns_ = (Integer)this.map_.get("independentRuns");
        this.outputParetoFrontFile_ = (String)this.map_.get("outputParetoFrontFile");
        this.outputParetoSetFile_ = (String)this.map_.get("outputParetoSetFile");
        int numberOfAlgorithms = this.algorithmNameList_.length;
        Algorithm[] algorithm = new Algorithm[numberOfAlgorithms];
        SolutionSet resultFront = null;
        while (!finished) {
            int[] problemData = null;
            problemData = this.experiment_.getNextProblem();
            if (finished || problemData == null) continue;
            int problemId = problemData[0];
            int alg = problemData[1];
            int runs = problemData[2];
            String problemName = this.problemList_[problemId];
            try {
                this.experiment_.algorithmSettings(problemName, problemId, algorithm);
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            Problem problem = algorithm[0].getProblem();
            String directory = this.experimentBaseDirectory_ + "/data/" + this.algorithmNameList_[alg] + "/" + this.problemList_[problemId];
            File experimentDirectory = new File(directory);
            if (!experimentDirectory.exists()) {
                boolean result = new File(directory).mkdirs();
                System.out.println("Creating " + directory);
            }
            System.out.println(Thread.currentThread().getName() + " Running algorithm: " + this.algorithmNameList_[alg] + ", problem: " + this.problemList_[problemId] + ", run: " + runs);
            try {
                try {
                    resultFront = algorithm[alg].execute();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            catch (JMException ex) {
                Logger.getLogger(Experiment.class.getName()).log(Level.SEVERE, null, ex);
            }
            resultFront.printObjectivesToFile(directory + "/" + this.outputParetoFrontFile_ + "." + runs);
            resultFront.printVariablesToFile(directory + "/" + this.outputParetoSetFile_ + "." + runs);
            if (finished || !this.experiment_.finished_) continue;
            finished = true;
        }
    }
}

