/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.cellde;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.Neighborhood;
import jmetal.util.PseudoRandom;
import jmetal.util.Ranking;
import jmetal.util.archive.SPEA2DensityArchive;
import jmetal.util.comparators.CrowdingComparator;
import jmetal.util.comparators.DominanceComparator;

public class CellDE
extends Algorithm {
    public CellDE(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        DominanceComparator dominance = new DominanceComparator();
        CrowdingComparator crowding = new CrowdingComparator();
        Distance distance = new Distance();
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int archiveSize = (Integer)this.getInputParameter("archiveSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        int feedBack = (Integer)this.getInputParameter("feedBack");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        SolutionSet currentSolutionSet = new SolutionSet(populationSize);
        SPEA2DensityArchive archive = new SPEA2DensityArchive(archiveSize);
        int evaluations = 0;
        Neighborhood neighborhood = new Neighborhood(populationSize);
        SolutionSet[] neighbors = new SolutionSet[populationSize];
        for (int i = 0; i < populationSize; ++i) {
            Solution solution = new Solution(this.problem_);
            this.problem_.evaluate(solution);
            this.problem_.evaluateConstraints(solution);
            currentSolutionSet.add(solution);
            solution.setLocation(i);
            ++evaluations;
        }
        while (evaluations < maxEvaluations) {
            for (int ind = 0; ind < currentSolutionSet.size(); ++ind) {
                Solution individual = new Solution(currentSolutionSet.get(ind));
                Solution[] parents = new Solution[3];
                neighbors[ind] = neighborhood.getEightNeighbors(currentSolutionSet, ind);
                parents[0] = (Solution)selectionOperator.execute(neighbors[ind]);
                parents[1] = (Solution)selectionOperator.execute(neighbors[ind]);
                parents[2] = individual;
                Solution offSpring = (Solution)crossoverOperator.execute(new Object[]{individual, parents});
                this.problem_.evaluate(offSpring);
                this.problem_.evaluateConstraints(offSpring);
                ++evaluations;
                int flag = dominance.compare(individual, offSpring);
                if (flag == 1) {
                    offSpring.setLocation(individual.getLocation());
                    currentSolutionSet.replace(ind, new Solution(offSpring));
                    ((SolutionSet)archive).add(new Solution(offSpring));
                    continue;
                }
                if (flag != 0) continue;
                neighbors[ind].add(offSpring);
                Ranking rank = new Ranking(neighbors[ind]);
                for (int j = 0; j < rank.getNumberOfSubfronts(); ++j) {
                    distance.crowdingDistanceAssignment(rank.getSubfront(j), this.problem_.getNumberOfObjectives());
                }
                boolean deleteMutant = true;
                int compareResult = crowding.compare(individual, offSpring);
                if (compareResult == 1) {
                    deleteMutant = false;
                }
                if (!deleteMutant) {
                    offSpring.setLocation(individual.getLocation());
                    currentSolutionSet.replace(offSpring.getLocation(), offSpring);
                    ((SolutionSet)archive).add(new Solution(offSpring));
                    continue;
                }
                ((SolutionSet)archive).add(new Solution(offSpring));
            }
            for (int j = 0; j < feedBack; ++j) {
                int r;
                if (archive.size() <= j || (r = PseudoRandom.randInt(0, currentSolutionSet.size() - 1)) >= currentSolutionSet.size()) continue;
                Solution individual = archive.get(j);
                individual.setLocation(r);
                currentSolutionSet.replace(r, new Solution(individual));
            }
        }
        return archive;
    }
}

