/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.densea;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.densea.DENSEA;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.BinaryTournament;
import jmetal.problems.ZDT.ZDT5;
import jmetal.util.Configuration;
import jmetal.util.JMException;

public class DENSEA_main {
    public static Logger logger_;
    public static FileHandler fileHandler_;

    public static void main(String[] args) throws JMException, IOException, ClassNotFoundException {
        logger_ = Configuration.logger_;
        fileHandler_ = new FileHandler("Densea.log");
        logger_.addHandler(fileHandler_);
        ZDT5 problem = new ZDT5("Binary");
        DENSEA algorithm = new DENSEA(problem);
        algorithm.setInputParameter("populationSize", 100);
        algorithm.setInputParameter("maxEvaluations", 25000);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", 0.9);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SinglePointCrossover", parameters);
        crossover.setParameter("probability", 0.9);
        parameters = new HashMap();
        parameters.put("probability", 0.006711409395973154);
        Mutation mutation = MutationFactory.getMutationOperator("BitFlipMutation", parameters);
        parameters = null;
        BinaryTournament selection = new BinaryTournament(parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        System.out.println("Total time of execution: " + estimatedTime);
        logger_.info("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        logger_.info("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
    }
}

