/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.mocell;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.Neighborhood;
import jmetal.util.Ranking;
import jmetal.util.archive.CrowdingArchive;
import jmetal.util.comparators.CrowdingComparator;
import jmetal.util.comparators.DominanceComparator;

public class aMOCell2
extends Algorithm {
    public aMOCell2(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        DominanceComparator dominance = new DominanceComparator();
        CrowdingComparator crowding = new CrowdingComparator();
        Distance distance = new Distance();
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int archiveSize = (Integer)this.getInputParameter("archiveSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        SolutionSet currentSolutionSet = new SolutionSet(populationSize);
        CrowdingArchive archive = new CrowdingArchive(archiveSize, this.problem_.getNumberOfObjectives());
        int evaluations = 0;
        Neighborhood neighborhood = new Neighborhood(populationSize);
        SolutionSet[] neighbors = new SolutionSet[populationSize];
        for (int i = 0; i < populationSize; ++i) {
            Solution solution = new Solution(this.problem_);
            this.problem_.evaluate(solution);
            this.problem_.evaluateConstraints(solution);
            currentSolutionSet.add(solution);
            solution.setLocation(i);
            ++evaluations;
        }
        while (evaluations < maxEvaluations) {
            for (int ind = 0; ind < currentSolutionSet.size(); ++ind) {
                Solution individual = new Solution(currentSolutionSet.get(ind));
                Solution[] parents = new Solution[2];
                neighbors[ind] = neighborhood.getEightNeighbors(currentSolutionSet, ind);
                neighbors[ind].add(individual);
                parents[0] = (Solution)selectionOperator.execute(neighbors[ind]);
                parents[1] = archive.size() > 0 ? (Solution)selectionOperator.execute(archive) : (Solution)selectionOperator.execute(neighbors[ind]);
                Solution[] offSpring = (Solution[])crossoverOperator.execute(parents);
                mutationOperator.execute(offSpring[0]);
                this.problem_.evaluate(offSpring[0]);
                this.problem_.evaluateConstraints(offSpring[0]);
                ++evaluations;
                int flag = dominance.compare(individual, offSpring[0]);
                if (flag == 1) {
                    offSpring[0].setLocation(individual.getLocation());
                    currentSolutionSet.replace(offSpring[0].getLocation(), offSpring[0]);
                    archive.add(new Solution(offSpring[0]));
                    continue;
                }
                if (flag != 0) continue;
                neighbors[ind].add(offSpring[0]);
                Ranking rank = new Ranking(neighbors[ind]);
                for (int j = 0; j < rank.getNumberOfSubfronts(); ++j) {
                    distance.crowdingDistanceAssignment(rank.getSubfront(j), this.problem_.getNumberOfObjectives());
                }
                boolean deleteMutant = true;
                int compareResult = crowding.compare(individual, offSpring[0]);
                if (compareResult == 1) {
                    deleteMutant = false;
                }
                if (!deleteMutant) {
                    offSpring[0].setLocation(individual.getLocation());
                    currentSolutionSet.replace(offSpring[0].getLocation(), offSpring[0]);
                    archive.add(new Solution(offSpring[0]));
                    continue;
                }
                archive.add(new Solution(offSpring[0]));
            }
        }
        return archive;
    }
}

