/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.mocell;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.Neighborhood;
import jmetal.util.PseudoRandom;
import jmetal.util.Ranking;
import jmetal.util.archive.CrowdingArchive;
import jmetal.util.comparators.CrowdingComparator;
import jmetal.util.comparators.DominanceComparator;

public class aMOCell3
extends Algorithm {
    public aMOCell3(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        Solution individual;
        DominanceComparator dominance = new DominanceComparator();
        CrowdingComparator crowdingComparator = new CrowdingComparator();
        Distance distance = new Distance();
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int archiveSize = (Integer)this.getInputParameter("archiveSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        int feedBack = (Integer)this.getInputParameter("feedBack");
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        Operator crossoverOperator = (Operator)this.operators_.get("crossover");
        Operator selectionOperator = (Operator)this.operators_.get("selection");
        SolutionSet currentPopulation = new SolutionSet(populationSize);
        CrowdingArchive archive = new CrowdingArchive(archiveSize, this.problem_.getNumberOfObjectives());
        int evaluations = 0;
        Neighborhood neighborhood = new Neighborhood(populationSize);
        SolutionSet[] neighbors = new SolutionSet[populationSize];
        dominance = new DominanceComparator();
        for (int i = 0; i < populationSize; ++i) {
            individual = new Solution(this.problem_);
            this.problem_.evaluate(individual);
            this.problem_.evaluateConstraints(individual);
            currentPopulation.add(individual);
            individual.setLocation(i);
            ++evaluations;
        }
        while (evaluations < maxEvaluations) {
            for (int ind = 0; ind < currentPopulation.size(); ++ind) {
                individual = new Solution(currentPopulation.get(ind));
                Solution[] parents = new Solution[2];
                neighbors[ind] = neighborhood.getEightNeighbors(currentPopulation, ind);
                neighbors[ind].add(individual);
                parents[0] = (Solution)selectionOperator.execute(neighbors[ind]);
                parents[1] = (Solution)selectionOperator.execute(neighbors[ind]);
                Solution[] offSpring = (Solution[])crossoverOperator.execute(parents);
                mutationOperator.execute(offSpring[0]);
                this.problem_.evaluate(offSpring[0]);
                this.problem_.evaluateConstraints(offSpring[0]);
                ++evaluations;
                int flag = dominance.compare(individual, offSpring[0]);
                if (flag == 1) {
                    offSpring[0].setLocation(individual.getLocation());
                    currentPopulation.replace(offSpring[0].getLocation(), offSpring[0]);
                    archive.add(new Solution(offSpring[0]));
                    continue;
                }
                if (flag != 0) continue;
                neighbors[ind].add(offSpring[0]);
                offSpring[0].setLocation(-1);
                Ranking rank = new Ranking(neighbors[ind]);
                for (int j = 0; j < rank.getNumberOfSubfronts(); ++j) {
                    distance.crowdingDistanceAssignment(rank.getSubfront(j), this.problem_.getNumberOfObjectives());
                }
                Solution worst = neighbors[ind].worst(crowdingComparator);
                if (worst.getLocation() == -1) {
                    archive.add(new Solution(offSpring[0]));
                    continue;
                }
                offSpring[0].setLocation(worst.getLocation());
                currentPopulation.replace(offSpring[0].getLocation(), offSpring[0]);
                archive.add(new Solution(offSpring[0]));
            }
            distance.crowdingDistanceAssignment(archive, this.problem_.getNumberOfObjectives());
            for (int j = 0; j < feedBack; ++j) {
                int r;
                if (archive.size() <= j || (r = PseudoRandom.randInt(0, currentPopulation.size() - 1)) >= currentPopulation.size()) continue;
                Solution individual2 = archive.get(j);
                individual2.setLocation(r);
                currentPopulation.replace(r, new Solution(individual2));
            }
        }
        return archive;
    }
}

