/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.mochc;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.encodings.variable.Binary;
import jmetal.util.JMException;
import jmetal.util.archive.CrowdingArchive;
import jmetal.util.comparators.CrowdingComparator;

public class MOCHC
extends Algorithm {
    public MOCHC(Problem problem) {
        super(problem);
    }

    public boolean equals(SolutionSet solutionSet, SolutionSet newSolutionSet) {
        for (int i = 0; i < solutionSet.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < newSolutionSet.size(); ++j) {
                if (!solutionSet.get(i).equals(newSolutionSet.get(j))) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int hammingDistance(Solution solutionOne, Solution solutionTwo) {
        int distance = 0;
        for (int i = 0; i < this.problem_.getNumberOfVariables(); ++i) {
            distance += ((Binary)solutionOne.getDecisionVariables()[i]).hammingDistance((Binary)solutionTwo.getDecisionVariables()[i]);
        }
        return distance;
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int i;
        CrowdingComparator crowdingComparator = new CrowdingComparator();
        boolean condition = false;
        double initialConvergenceCount = (Double)this.getInputParameter("initialConvergenceCount");
        double preservedPopulation = (Double)this.getInputParameter("preservedPopulation");
        int convergenceValue = (Integer)this.getInputParameter("convergenceValue");
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        Operator crossover = this.getOperator("crossover");
        Operator cataclysmicMutation = this.getOperator("cataclysmicMutation");
        Operator parentSelection = this.getOperator("parentSelection");
        Operator newGenerationSelection = this.getOperator("newGenerationSelection");
        int iterations = 0;
        int evaluations = 0;
        Solution aux = new Solution(this.problem_);
        int size = 0;
        for (int var = 0; var < this.problem_.getNumberOfVariables(); ++var) {
            size += ((Binary)aux.getDecisionVariables()[var]).getNumberOfBits();
        }
        int minimumDistance = (int)Math.floor(initialConvergenceCount * (double)size);
        SolutionSet solutionSet = new SolutionSet(populationSize);
        for (i = 0; i < populationSize; ++i) {
            Solution solution = new Solution(this.problem_);
            this.problem_.evaluate(solution);
            this.problem_.evaluateConstraints(solution);
            ++evaluations;
            solutionSet.add(solution);
        }
        while (!condition) {
            SolutionSet offspringPopulation = new SolutionSet(populationSize);
            for (i = 0; i < solutionSet.size() / 2; ++i) {
                Solution[] parents = (Solution[])parentSelection.execute(solutionSet);
                if (this.hammingDistance(parents[0], parents[1]) < minimumDistance) continue;
                Solution[] offspring = (Solution[])crossover.execute(parents);
                this.problem_.evaluate(offspring[0]);
                this.problem_.evaluateConstraints(offspring[0]);
                this.problem_.evaluate(offspring[1]);
                this.problem_.evaluateConstraints(offspring[1]);
                evaluations += 2;
                offspringPopulation.add(offspring[0]);
                offspringPopulation.add(offspring[1]);
            }
            SolutionSet union = solutionSet.union(offspringPopulation);
            newGenerationSelection.setParameter("populationSize", populationSize);
            SolutionSet newPopulation = (SolutionSet)newGenerationSelection.execute(union);
            if (this.equals(solutionSet, newPopulation)) {
                --minimumDistance;
            }
            if (minimumDistance <= -convergenceValue) {
                int i2;
                minimumDistance = (int)(1.0 / (double)size * (1.0 - 1.0 / (double)size) * (double)size);
                int preserve = (int)Math.floor(preservedPopulation * (double)populationSize);
                newPopulation = new SolutionSet(populationSize);
                solutionSet.sort(crowdingComparator);
                for (i2 = 0; i2 < preserve; ++i2) {
                    newPopulation.add(new Solution(solutionSet.get(i2)));
                }
                for (i2 = preserve; i2 < populationSize; ++i2) {
                    Solution solution = new Solution(solutionSet.get(i2));
                    cataclysmicMutation.execute(solution);
                    this.problem_.evaluate(solution);
                    this.problem_.evaluateConstraints(solution);
                    newPopulation.add(solution);
                }
            }
            ++iterations;
            solutionSet = newPopulation;
            if (evaluations < maxEvaluations) continue;
            condition = true;
        }
        CrowdingArchive archive = new CrowdingArchive(populationSize, this.problem_.getNumberOfObjectives());
        for (int i3 = 0; i3 < solutionSet.size(); ++i3) {
            archive.add(solutionSet.get(i3));
        }
        return archive;
    }
}

