/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.mochc;

import java.io.Serializable;
import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.mochc.MOCHC;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.ZDT.ZDT5;

public class MOCHC_main {
    public static void main(String[] args) {
        try {
            ZDT5 problem = new ZDT5("Binary");
            MOCHC algorithm = null;
            algorithm = new MOCHC(problem);
            algorithm.setInputParameter("initialConvergenceCount", 0.25);
            algorithm.setInputParameter("preservedPopulation", 0.05);
            algorithm.setInputParameter("convergenceValue", 3);
            algorithm.setInputParameter("populationSize", 100);
            algorithm.setInputParameter("maxEvaluations", 60000);
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("probability", Double.valueOf(1.0));
            Crossover crossoverOperator = CrossoverFactory.getCrossoverOperator("HUXCrossover", parameters);
            parameters = null;
            Selection parentsSelection = SelectionFactory.getSelectionOperator("RandomSelection", parameters);
            parameters = new HashMap();
            parameters.put("problem", problem);
            Selection newGenerationSelection = SelectionFactory.getSelectionOperator("RankingAndCrowdingSelection", parameters);
            parameters = new HashMap();
            parameters.put("probability", Double.valueOf(0.35));
            Mutation mutationOperator = MutationFactory.getMutationOperator("BitFlipMutation", parameters);
            algorithm.addOperator("crossover", crossoverOperator);
            algorithm.addOperator("cataclysmicMutation", mutationOperator);
            algorithm.addOperator("parentSelection", parentsSelection);
            algorithm.addOperator("newGenerationSelection", newGenerationSelection);
            long initTime = System.currentTimeMillis();
            SolutionSet population = ((Algorithm)algorithm).execute();
            long estimatedTime = System.currentTimeMillis() - initTime;
            System.out.println("Total execution time: " + estimatedTime);
            population.printVariablesToFile("VAR");
            population.printObjectivesToFile("FUN");
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

