/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.moead;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.moead.Utils;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class MOEAD
extends Algorithm {
    private int populationSize_;
    private SolutionSet population_;
    double[] z_;
    double[][] lambda_;
    int T_;
    int[][] neighborhood_;
    double delta_;
    int nr_;
    Solution[] indArray_;
    String functionType_ = "_TCHE1";
    int evaluations_;
    Operator crossover_;
    Operator mutation_;
    String dataDirectory_;

    public MOEAD(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        this.evaluations_ = 0;
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        this.populationSize_ = (Integer)this.getInputParameter("populationSize");
        this.dataDirectory_ = this.getInputParameter("dataDirectory").toString();
        this.population_ = new SolutionSet(this.populationSize_);
        this.indArray_ = new Solution[this.problem_.getNumberOfObjectives()];
        this.T_ = 20;
        this.delta_ = 0.9;
        this.nr_ = 2;
        this.neighborhood_ = new int[this.populationSize_][this.T_];
        this.z_ = new double[this.problem_.getNumberOfObjectives()];
        this.lambda_ = new double[this.populationSize_][this.problem_.getNumberOfObjectives()];
        this.crossover_ = (Operator)this.operators_.get("crossover");
        this.mutation_ = (Operator)this.operators_.get("mutation");
        this.initUniformWeight();
        this.initNeighborhood();
        this.initPopulation();
        this.initIdealPoint();
        do {
            int[] permutation = new int[this.populationSize_];
            Utils.randomPermutation(permutation, this.populationSize_);
            for (int i = 0; i < this.populationSize_; ++i) {
                int n = i;
                double rnd = PseudoRandom.randDouble();
                int type = rnd < this.delta_ ? 1 : 2;
                Vector<Integer> p = new Vector<Integer>();
                this.matingSelection(p, n, 2, type);
                Solution[] parents = new Solution[]{this.population_.get(p.get(0)), this.population_.get(p.get(1)), this.population_.get(n)};
                Solution child = (Solution)this.crossover_.execute(new Object[]{this.population_.get(n), parents});
                this.mutation_.execute(child);
                this.problem_.evaluate(child);
                ++this.evaluations_;
                this.updateReference(child);
                this.updateProblem(child, n, type);
            }
        } while (this.evaluations_ < maxEvaluations);
        return this.population_;
    }

    public void initUniformWeight() {
        if (this.problem_.getNumberOfObjectives() == 2 && this.populationSize_ <= 300) {
            for (int n = 0; n < this.populationSize_; ++n) {
                double a;
                this.lambda_[n][0] = a = 1.0 * (double)n / (double)(this.populationSize_ - 1);
                this.lambda_[n][1] = 1.0 - a;
            }
        } else {
            String dataFileName = "W" + this.problem_.getNumberOfObjectives() + "D_" + this.populationSize_ + ".dat";
            try {
                FileInputStream fis = new FileInputStream(this.dataDirectory_ + "/" + dataFileName);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                int numberOfObjectives = 0;
                int i = 0;
                int j = 0;
                String aux = br.readLine();
                while (aux != null) {
                    StringTokenizer st = new StringTokenizer(aux);
                    j = 0;
                    numberOfObjectives = st.countTokens();
                    while (st.hasMoreTokens()) {
                        double value;
                        this.lambda_[i][j] = value = new Double(st.nextToken()).doubleValue();
                        ++j;
                    }
                    aux = br.readLine();
                    ++i;
                }
                br.close();
            }
            catch (Exception e) {
                System.out.println("initUniformWeight: failed when reading for file: " + this.dataDirectory_ + "/" + dataFileName);
                e.printStackTrace();
            }
        }
    }

    public void initNeighborhood() {
        double[] x = new double[this.populationSize_];
        int[] idx = new int[this.populationSize_];
        for (int i = 0; i < this.populationSize_; ++i) {
            for (int j = 0; j < this.populationSize_; ++j) {
                x[j] = Utils.distVector(this.lambda_[i], this.lambda_[j]);
                idx[j] = j;
            }
            Utils.minFastSort(x, idx, this.populationSize_, this.T_);
            for (int k = 0; k < this.T_; ++k) {
                this.neighborhood_[i][k] = idx[k];
            }
        }
    }

    public void initPopulation() throws JMException, ClassNotFoundException {
        for (int i = 0; i < this.populationSize_; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.problem_.evaluate(newSolution);
            ++this.evaluations_;
            this.population_.add(newSolution);
        }
    }

    void initIdealPoint() throws JMException, ClassNotFoundException {
        int i;
        for (i = 0; i < this.problem_.getNumberOfObjectives(); ++i) {
            this.z_[i] = 1.0E30;
            this.indArray_[i] = new Solution(this.problem_);
            this.problem_.evaluate(this.indArray_[i]);
            ++this.evaluations_;
        }
        for (i = 0; i < this.populationSize_; ++i) {
            this.updateReference(this.population_.get(i));
        }
    }

    public void matingSelection(Vector<Integer> list, int cid, int size, int type) {
        int ss = this.neighborhood_[cid].length;
        while (list.size() < size) {
            int p;
            if (type == 1) {
                int r = PseudoRandom.randInt(0, ss - 1);
                p = this.neighborhood_[cid][r];
            } else {
                p = PseudoRandom.randInt(0, this.populationSize_ - 1);
            }
            boolean flag = true;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != p) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            list.addElement(p);
        }
    }

    void updateReference(Solution individual) {
        for (int n = 0; n < this.problem_.getNumberOfObjectives(); ++n) {
            if (!(individual.getObjective(n) < this.z_[n])) continue;
            this.z_[n] = individual.getObjective(n);
            this.indArray_[n] = individual;
        }
    }

    void updateProblem(Solution indiv, int id, int type) {
        int time = 0;
        int size = type == 1 ? this.neighborhood_[id].length : this.population_.size();
        int[] perm = new int[size];
        Utils.randomPermutation(perm, size);
        for (int i = 0; i < size; ++i) {
            int k = type == 1 ? this.neighborhood_[id][perm[i]] : perm[i];
            double f1 = this.fitnessFunction(this.population_.get(k), this.lambda_[k]);
            double f2 = this.fitnessFunction(indiv, this.lambda_[k]);
            if (f2 < f1) {
                this.population_.replace(k, new Solution(indiv));
                ++time;
            }
            if (time < this.nr_) continue;
            return;
        }
    }

    double fitnessFunction(Solution individual, double[] lambda) {
        double fitness = 0.0;
        if (this.functionType_.equals("_TCHE1")) {
            double maxFun = -1.0E30;
            for (int n = 0; n < this.problem_.getNumberOfObjectives(); ++n) {
                double diff = Math.abs(individual.getObjective(n) - this.z_[n]);
                double feval = lambda[n] == 0.0 ? 1.0E-4 * diff : diff * lambda[n];
                if (!(feval > maxFun)) continue;
                maxFun = feval;
            }
            fitness = maxFun;
        } else {
            System.out.println("MOEAD.fitnessFunction: unknown type " + this.functionType_);
            System.exit(-1);
        }
        return fitness;
    }
}

