/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.moead;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.moead.Utils;
import jmetal.util.Distance;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class MOEAD_DRA
extends Algorithm {
    private int populationSize_;
    private SolutionSet population_;
    private Solution[] savedValues_;
    private double[] utility_;
    private int[] frequency_;
    double[] z_;
    double[][] lambda_;
    int T_;
    int[][] neighborhood_;
    double delta_;
    int nr_;
    Solution[] indArray_;
    String functionType_ = "_TCHE1";
    int evaluations_;
    Operator crossover_;
    Operator mutation_;
    String dataDirectory_;

    public MOEAD_DRA(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        this.evaluations_ = 0;
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        this.populationSize_ = (Integer)this.getInputParameter("populationSize");
        this.dataDirectory_ = this.getInputParameter("dataDirectory").toString();
        this.population_ = new SolutionSet(this.populationSize_);
        this.savedValues_ = new Solution[this.populationSize_];
        this.utility_ = new double[this.populationSize_];
        this.frequency_ = new int[this.populationSize_];
        for (int i = 0; i < this.utility_.length; ++i) {
            this.utility_[i] = 1.0;
            this.frequency_[i] = 0;
        }
        this.indArray_ = new Solution[this.problem_.getNumberOfObjectives()];
        this.T_ = (int)(0.1 * (double)this.populationSize_);
        this.delta_ = 0.9;
        this.nr_ = (int)(0.01 * (double)this.populationSize_);
        this.neighborhood_ = new int[this.populationSize_][this.T_];
        this.z_ = new double[this.problem_.getNumberOfObjectives()];
        this.lambda_ = new double[this.populationSize_][this.problem_.getNumberOfObjectives()];
        this.crossover_ = (Operator)this.operators_.get("crossover");
        this.mutation_ = (Operator)this.operators_.get("mutation");
        this.initUniformWeight();
        this.initNeighborhood();
        this.initPopulation();
        this.initIdealPoint();
        int gen = 0;
        do {
            int[] permutation = new int[this.populationSize_];
            Utils.randomPermutation(permutation, this.populationSize_);
            List<Integer> order = this.tour_selection(10);
            for (int i = 0; i < order.size(); ++i) {
                int n;
                int n2 = n = order.get(i).intValue();
                this.frequency_[n2] = this.frequency_[n2] + 1;
                double rnd = PseudoRandom.randDouble();
                int type = rnd < this.delta_ ? 1 : 2;
                Vector<Integer> p = new Vector<Integer>();
                this.matingSelection(p, n, 2, type);
                Solution[] parents = new Solution[]{this.population_.get(p.get(0)), this.population_.get(p.get(1)), this.population_.get(n)};
                Solution child = (Solution)this.crossover_.execute(new Object[]{this.population_.get(n), parents});
                this.mutation_.execute(child);
                this.problem_.evaluate(child);
                ++this.evaluations_;
                this.updateReference(child);
                this.updateProblem(child, n, type);
            }
            if (++gen % 30 != 0) continue;
            this.comp_utility();
        } while (this.evaluations_ < maxEvaluations);
        int final_size = this.populationSize_;
        try {
            final_size = (Integer)this.getInputParameter("finalSize");
            System.out.println("FINAL SOZE: " + final_size);
        }
        catch (Exception e) {
            System.err.println("The final size paramater has been ignored");
            System.err.println("The number of solutions is " + this.population_.size());
            return this.population_;
        }
        return this.finalSelection(final_size);
    }

    public void initUniformWeight() {
        if (this.problem_.getNumberOfObjectives() == 2 && this.populationSize_ <= 100) {
            for (int n = 0; n < this.populationSize_; ++n) {
                double a;
                this.lambda_[n][0] = a = 1.0 * (double)n / (double)(this.populationSize_ - 1);
                this.lambda_[n][1] = 1.0 - a;
            }
        } else {
            String dataFileName = "W" + this.problem_.getNumberOfObjectives() + "D_" + this.populationSize_ + ".dat";
            try {
                FileInputStream fis = new FileInputStream(this.dataDirectory_ + "/" + dataFileName);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                int numberOfObjectives = 0;
                int i = 0;
                int j = 0;
                String aux = br.readLine();
                while (aux != null) {
                    StringTokenizer st = new StringTokenizer(aux);
                    j = 0;
                    numberOfObjectives = st.countTokens();
                    while (st.hasMoreTokens()) {
                        double value;
                        this.lambda_[i][j] = value = new Double(st.nextToken()).doubleValue();
                        ++j;
                    }
                    aux = br.readLine();
                    ++i;
                }
                br.close();
            }
            catch (Exception e) {
                System.err.println("initUniformWeight: failed when reading for file: " + this.dataDirectory_ + "/" + dataFileName);
                e.printStackTrace();
            }
        }
    }

    public void comp_utility() {
        for (int n = 0; n < this.populationSize_; ++n) {
            double uti;
            double f1 = this.fitnessFunction(this.population_.get(n), this.lambda_[n]);
            double f2 = this.fitnessFunction(this.savedValues_[n], this.lambda_[n]);
            double delta = f2 - f1;
            this.utility_[n] = delta > 0.001 ? 1.0 : ((uti = (0.95 + 0.05 * delta / 0.001) * this.utility_[n]) < 1.0 ? uti : 1.0);
            this.savedValues_[n] = new Solution(this.population_.get(n));
        }
    }

    public void initNeighborhood() {
        double[] x = new double[this.populationSize_];
        int[] idx = new int[this.populationSize_];
        for (int i = 0; i < this.populationSize_; ++i) {
            for (int j = 0; j < this.populationSize_; ++j) {
                x[j] = Utils.distVector(this.lambda_[i], this.lambda_[j]);
                idx[j] = j;
            }
            Utils.minFastSort(x, idx, this.populationSize_, this.T_);
            for (int k = 0; k < this.T_; ++k) {
                this.neighborhood_[i][k] = idx[k];
            }
        }
    }

    public void initPopulation() throws JMException, ClassNotFoundException {
        for (int i = 0; i < this.populationSize_; ++i) {
            Solution newSolution = new Solution(this.problem_);
            this.problem_.evaluate(newSolution);
            ++this.evaluations_;
            this.population_.add(newSolution);
            this.savedValues_[i] = new Solution(newSolution);
        }
    }

    void initIdealPoint() throws JMException, ClassNotFoundException {
        int i;
        for (i = 0; i < this.problem_.getNumberOfObjectives(); ++i) {
            this.z_[i] = 1.0E30;
            this.indArray_[i] = new Solution(this.problem_);
            this.problem_.evaluate(this.indArray_[i]);
            ++this.evaluations_;
        }
        for (i = 0; i < this.populationSize_; ++i) {
            this.updateReference(this.population_.get(i));
        }
    }

    public void matingSelection(Vector<Integer> list, int cid, int size, int type) {
        int ss = this.neighborhood_[cid].length;
        while (list.size() < size) {
            int p;
            if (type == 1) {
                int r = PseudoRandom.randInt(0, ss - 1);
                p = this.neighborhood_[cid][r];
            } else {
                p = PseudoRandom.randInt(0, this.populationSize_ - 1);
            }
            boolean flag = true;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != p) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            list.addElement(p);
        }
    }

    public List<Integer> tour_selection(int depth) {
        ArrayList<Integer> selected = new ArrayList<Integer>();
        ArrayList<Integer> candidate = new ArrayList<Integer>();
        for (int k = 0; k < this.problem_.getNumberOfObjectives(); ++k) {
            selected.add(k);
        }
        for (int n = this.problem_.getNumberOfObjectives(); n < this.populationSize_; ++n) {
            candidate.add(n);
        }
        while (selected.size() < (int)((double)this.populationSize_ / 5.0)) {
            int best_idd = (int)(PseudoRandom.randDouble() * (double)candidate.size());
            int best_sub = (Integer)candidate.get(best_idd);
            for (int i = 1; i < depth; ++i) {
                int i2 = (int)(PseudoRandom.randDouble() * (double)candidate.size());
                int s2 = (Integer)candidate.get(i2);
                if (!(this.utility_[s2] > this.utility_[best_sub])) continue;
                best_idd = i2;
                best_sub = s2;
            }
            selected.add(best_sub);
            candidate.remove(best_idd);
        }
        return selected;
    }

    void updateReference(Solution individual) {
        for (int n = 0; n < this.problem_.getNumberOfObjectives(); ++n) {
            if (!(individual.getObjective(n) < this.z_[n])) continue;
            this.z_[n] = individual.getObjective(n);
            this.indArray_[n] = individual;
        }
    }

    void updateProblem(Solution indiv, int id, int type) {
        int time = 0;
        int size = type == 1 ? this.neighborhood_[id].length : this.population_.size();
        int[] perm = new int[size];
        Utils.randomPermutation(perm, size);
        for (int i = 0; i < size; ++i) {
            int k = type == 1 ? this.neighborhood_[id][perm[i]] : perm[i];
            double f1 = this.fitnessFunction(this.population_.get(k), this.lambda_[k]);
            double f2 = this.fitnessFunction(indiv, this.lambda_[k]);
            if (f2 < f1) {
                this.population_.replace(k, new Solution(indiv));
                ++time;
            }
            if (time < this.nr_) continue;
            return;
        }
    }

    double fitnessFunction(Solution individual, double[] lambda) {
        double fitness = 0.0;
        if (this.functionType_.equals("_TCHE1")) {
            double maxFun = -1.0E30;
            for (int n = 0; n < this.problem_.getNumberOfObjectives(); ++n) {
                double diff = Math.abs(individual.getObjective(n) - this.z_[n]);
                double feval = lambda[n] == 0.0 ? 1.0E-4 * diff : diff * lambda[n];
                if (!(feval > maxFun)) continue;
                maxFun = feval;
            }
            fitness = maxFun;
        } else {
            System.err.println("MOEAD.fitnessFunction: unknown type " + this.functionType_);
            System.exit(-1);
        }
        return fitness;
    }

    SolutionSet finalSelection(int n) throws JMException {
        SolutionSet res = new SolutionSet(n);
        if (this.problem_.getNumberOfObjectives() == 2) {
            int i;
            double[][] intern_lambda = new double[n][2];
            for (i = 0; i < n; ++i) {
                double a;
                intern_lambda[i][0] = a = 1.0 * (double)i / (double)(n - 1);
                intern_lambda[i][1] = 1.0 - a;
            }
            for (i = 0; i < n; ++i) {
                Solution current_best = this.population_.get(0);
                boolean index = false;
                double value = this.fitnessFunction(current_best, intern_lambda[i]);
                for (int j = 1; j < n; ++j) {
                    double aux = this.fitnessFunction(this.population_.get(j), intern_lambda[i]);
                    if (!(aux < value)) continue;
                    value = aux;
                    current_best = this.population_.get(j);
                }
                res.add(new Solution(current_best));
            }
        } else {
            Distance distance_utility = new Distance();
            int random_index = PseudoRandom.randInt(0, this.population_.size() - 1);
            LinkedList<Solution> candidate = new LinkedList<Solution>();
            candidate.add(this.population_.get(random_index));
            for (int i = 0; i < this.population_.size(); ++i) {
                if (i == random_index) continue;
                candidate.add(this.population_.get(i));
            }
            while (res.size() < n) {
                int index = 0;
                Solution selected = (Solution)candidate.get(0);
                double distance_value = distance_utility.distanceToSolutionSetInObjectiveSpace(selected, res);
                for (int i = 1; i < candidate.size(); ++i) {
                    Solution next_candidate = (Solution)candidate.get(i);
                    distance_value = distance_utility.distanceToSolutionSetInObjectiveSpace(next_candidate, res);
                    double aux = distance_value;
                    if (!(aux > distance_value)) continue;
                    distance_value = aux;
                    index = i;
                }
                res.add(new Solution((Solution)candidate.remove(index)));
            }
        }
        return res;
    }
}

