/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.moead;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.Problem;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.moead.pMOEAD;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.Kursawe;
import jmetal.problems.ProblemFactory;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.util.Configuration;
import jmetal.util.JMException;

public class pMOEAD_main {
    public static Logger logger_;
    public static FileHandler fileHandler_;

    public static void main(String[] args) throws JMException, SecurityException, IOException, ClassNotFoundException {
        Problem problem;
        Object[] params;
        int numberOfThreads = 1;
        String dataDirectory = "";
        logger_ = Configuration.logger_;
        fileHandler_ = new FileHandler("pMOEAD.log");
        logger_.addHandler(fileHandler_);
        QualityIndicator indicators = null;
        if (args.length == 1) {
            params = new Object[]{"Real"};
            problem = new ProblemFactory().getProblem(args[0], params);
        } else if (args.length == 2) {
            params = new Object[]{"Real"};
            problem = new ProblemFactory().getProblem(args[0], params);
            indicators = new QualityIndicator(problem, args[1]);
        } else if (args.length == 3) {
            params = new Object[]{"Real"};
            problem = new ProblemFactory().getProblem(args[0], params);
            numberOfThreads = Integer.parseInt(args[1]);
            dataDirectory = args[2];
        } else {
            problem = new Kursawe("Real", 3);
        }
        pMOEAD algorithm = new pMOEAD(problem);
        numberOfThreads = 4;
        algorithm.setInputParameter("populationSize", 300);
        algorithm.setInputParameter("maxEvaluations", 150000);
        algorithm.setInputParameter("numberOfThreads", numberOfThreads);
        algorithm.setInputParameter("dataDirectory", "/Users/antonio/Softw/pruebas/data/MOEAD_parameters/Weight");
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("CR", 1.0);
        parameters.put("F", 0.5);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("DifferentialEvolutionCrossover", parameters);
        crossover.setParameter("CR", 1.0);
        crossover.setParameter("F", 0.5);
        parameters = new HashMap();
        parameters.put("probability", 1.0 / (double)problem.getNumberOfVariables());
        parameters.put("distributionIndex", 20.0);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        logger_.info("Total execution time: " + estimatedTime + " ms");
        logger_.info("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        logger_.info("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
        if (indicators != null) {
            logger_.info("Quality indicators");
            logger_.info("Hypervolume: " + indicators.getHypervolume(population));
            logger_.info("GD         : " + indicators.getGD(population));
            logger_.info("IGD        : " + indicators.getIGD(population));
            logger_.info("Spread     : " + indicators.getSpread(population));
        }
    }
}

