/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.paes;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.JMException;
import jmetal.util.archive.AdaptiveGridArchive;
import jmetal.util.comparators.DominanceComparator;

public class PAES
extends Algorithm {
    public PAES(Problem problem) {
        super(problem);
    }

    public Solution test(Solution solution, Solution mutatedSolution, AdaptiveGridArchive archive) {
        int originalLocation = archive.getGrid().location(solution);
        int mutatedLocation = archive.getGrid().location(mutatedSolution);
        if (originalLocation == -1) {
            return new Solution(mutatedSolution);
        }
        if (mutatedLocation == -1) {
            return new Solution(solution);
        }
        if (archive.getGrid().getLocationDensity(mutatedLocation) < archive.getGrid().getLocationDensity(originalLocation)) {
            return new Solution(mutatedSolution);
        }
        return new Solution(solution);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int bisections = (Integer)this.getInputParameter("biSections");
        int archiveSize = (Integer)this.getInputParameter("archiveSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        int evaluations = 0;
        AdaptiveGridArchive archive = new AdaptiveGridArchive(archiveSize, bisections, this.problem_.getNumberOfObjectives());
        DominanceComparator dominance = new DominanceComparator();
        Solution solution = new Solution(this.problem_);
        this.problem_.evaluate(solution);
        this.problem_.evaluateConstraints(solution);
        ++evaluations;
        archive.add(new Solution(solution));
        do {
            Solution mutatedIndividual = new Solution(solution);
            mutationOperator.execute(mutatedIndividual);
            this.problem_.evaluate(mutatedIndividual);
            this.problem_.evaluateConstraints(mutatedIndividual);
            ++evaluations;
            int flag = dominance.compare(solution, mutatedIndividual);
            if (flag == 1) {
                solution = new Solution(mutatedIndividual);
                archive.add(mutatedIndividual);
                continue;
            }
            if (flag != 0 || !archive.add(mutatedIndividual)) continue;
            solution = this.test(solution, mutatedIndividual, archive);
        } while (evaluations < maxEvaluations);
        return archive;
    }
}

