/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.pesa2;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.operators.selection.PESA2Selection;
import jmetal.util.JMException;
import jmetal.util.archive.AdaptiveGridArchive;

public class PESA2
extends Algorithm {
    public PESA2(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int i;
        int populationSize = (Integer)this.inputParameters_.get("populationSize");
        int archiveSize = (Integer)this.inputParameters_.get("archiveSize");
        int bisections = (Integer)this.inputParameters_.get("bisections");
        int maxEvaluations = (Integer)this.inputParameters_.get("maxEvaluations");
        Operator crossover = (Operator)this.operators_.get("crossover");
        Operator mutation = (Operator)this.operators_.get("mutation");
        int evaluations = 0;
        AdaptiveGridArchive archive = new AdaptiveGridArchive(archiveSize, bisections, this.problem_.getNumberOfObjectives());
        SolutionSet solutionSet = new SolutionSet(populationSize);
        HashMap<String, Object> parameters = null;
        PESA2Selection selection = new PESA2Selection(parameters);
        for (i = 0; i < populationSize; ++i) {
            Solution solution = new Solution(this.problem_);
            this.problem_.evaluate(solution);
            this.problem_.evaluateConstraints(solution);
            ++evaluations;
            solutionSet.add(solution);
        }
        for (i = 0; i < solutionSet.size(); ++i) {
            archive.add(solutionSet.get(i));
        }
        solutionSet.clear();
        Solution[] parents = new Solution[2];
        while (true) {
            if (solutionSet.size() < populationSize) {
                parents[0] = (Solution)((Operator)selection).execute(archive);
                parents[1] = (Solution)((Operator)selection).execute(archive);
                Solution[] offSpring = (Solution[])crossover.execute(parents);
                mutation.execute(offSpring[0]);
                this.problem_.evaluate(offSpring[0]);
                this.problem_.evaluateConstraints(offSpring[0]);
                ++evaluations;
                solutionSet.add(offSpring[0]);
                continue;
            }
            for (int i2 = 0; i2 < solutionSet.size(); ++i2) {
                archive.add(solutionSet.get(i2));
            }
            solutionSet.clear();
            if (evaluations >= maxEvaluations) break;
        }
        return archive;
    }
}

