/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.pesa2;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.Problem;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.pesa2.PESA2;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.Kursawe;
import jmetal.problems.ProblemFactory;
import jmetal.qualityIndicator.QualityIndicator;
import jmetal.util.Configuration;
import jmetal.util.JMException;

public class PESA2_main {
    public static Logger logger_;
    public static FileHandler fileHandler_;

    public static void main(String[] args) throws JMException, IOException, ClassNotFoundException {
        Problem problem;
        Object[] params;
        logger_ = Configuration.logger_;
        fileHandler_ = new FileHandler("PESA2_main.log");
        logger_.addHandler(fileHandler_);
        QualityIndicator indicators = null;
        if (args.length == 1) {
            params = new Object[]{"Real"};
            problem = new ProblemFactory().getProblem(args[0], params);
        } else if (args.length == 2) {
            params = new Object[]{"Real"};
            problem = new ProblemFactory().getProblem(args[0], params);
            indicators = new QualityIndicator(problem, args[1]);
        } else {
            problem = new Kursawe("Real", 3);
        }
        PESA2 algorithm = new PESA2(problem);
        algorithm.setInputParameter("populationSize", 10);
        algorithm.setInputParameter("archiveSize", 100);
        algorithm.setInputParameter("bisections", 5);
        algorithm.setInputParameter("maxEvaluations", 25000);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", 0.9);
        parameters.put("distributionIndex", 20.0);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SBXCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", 1.0 / (double)problem.getNumberOfVariables());
        parameters.put("distributionIndex", 20.0);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        System.out.println("Total execution time: " + estimatedTime);
        logger_.info("Total execution time: " + estimatedTime);
        logger_.info("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        logger_.info("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
    }
}

