/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.evolutionStrategy;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.singleObjective.evolutionStrategy.ElitistES;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.singleObjective.OneMax;
import jmetal.util.JMException;

public class ES_main {
    public static void main(String[] args) throws JMException, ClassNotFoundException {
        int bits = 512;
        OneMax problem = new OneMax("Binary", bits);
        int mu = 1;
        int lambda = 10;
        ElitistES algorithm = new ElitistES(problem, mu, lambda);
        algorithm.setInputParameter("maxEvaluations", 20000);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", 1.0 / (double)bits);
        Mutation mutation = MutationFactory.getMutationOperator("BitFlipMutation", parameters);
        algorithm.addOperator("mutation", mutation);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        System.out.println("Total execution time: " + estimatedTime);
        System.out.println("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        System.out.println("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
    }
}

