/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.evolutionStrategy;

import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.JMException;
import jmetal.util.comparators.ObjectiveComparator;

public class NonElitistES
extends Algorithm {
    private int mu_;
    private int lambda_;

    public NonElitistES(Problem problem, int mu, int lambda) {
        super(problem);
        this.mu_ = mu;
        this.lambda_ = lambda;
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        ObjectiveComparator comparator = new ObjectiveComparator(0);
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        SolutionSet population = new SolutionSet(this.mu_ + 1);
        SolutionSet offspringPopulation = new SolutionSet(this.lambda_);
        int evaluations = 0;
        Operator mutationOperator = (Operator)this.operators_.get("mutation");
        System.out.println("(" + this.mu_ + " , " + this.lambda_ + ")ES");
        Solution newIndividual = new Solution(this.problem_);
        this.problem_.evaluate(newIndividual);
        ++evaluations;
        population.add(newIndividual);
        Solution bestIndividual = new Solution(newIndividual);
        for (int i = 1; i < this.mu_; ++i) {
            System.out.println(i);
            newIndividual = new Solution(this.problem_);
            this.problem_.evaluate(newIndividual);
            ++evaluations;
            population.add(newIndividual);
            if (comparator.compare(bestIndividual, newIndividual) <= 0) continue;
            bestIndividual = new Solution(newIndividual);
        }
        int offsprings = this.lambda_ / this.mu_;
        while (evaluations < maxEvaluations) {
            int i;
            for (i = 0; i < this.mu_; ++i) {
                for (int j = 0; j < offsprings; ++j) {
                    Solution offspring = new Solution(population.get(i));
                    mutationOperator.execute(offspring);
                    this.problem_.evaluate(offspring);
                    offspringPopulation.add(offspring);
                    ++evaluations;
                }
            }
            offspringPopulation.sort(comparator);
            if (comparator.compare(bestIndividual, offspringPopulation.get(0)) > 0) {
                bestIndividual = new Solution(offspringPopulation.get(0));
            }
            population.clear();
            for (i = 0; i < this.mu_; ++i) {
                population.add(offspringPopulation.get(i));
            }
            System.out.println("Evaluation: " + evaluations + " Current best fitness: " + population.get(0).getObjective(0) + " Global best fitness: " + bestIndividual.getObjective(0));
            offspringPopulation.clear();
        }
        SolutionSet resultPopulation = new SolutionSet(1);
        resultPopulation.add(population.get(0));
        return resultPopulation;
    }
}

