/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.geneticAlgorithm;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.singleObjective.geneticAlgorithm.gGA;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.singleObjective.OneMax;
import jmetal.util.JMException;

public class GA_main {
    public static void main(String[] args) throws JMException, ClassNotFoundException {
        int bits = 512;
        OneMax problem = new OneMax("Binary", bits);
        gGA algorithm = new gGA(problem);
        algorithm.setInputParameter("populationSize", 100);
        algorithm.setInputParameter("maxEvaluations", 25000);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", 0.9);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SinglePointCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", 1.0 / (double)bits);
        Mutation mutation = MutationFactory.getMutationOperator("BitFlipMutation", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("BinaryTournament", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        System.out.println("Total execution time: " + estimatedTime);
        System.out.println("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        System.out.println("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
    }
}

