/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.geneticAlgorithm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.singleObjective.geneticAlgorithm.ssGA;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.singleObjective.TSP;
import jmetal.util.JMException;

public class TSPGA_main {
    public static void main(String[] args) throws FileNotFoundException, IOException, JMException, ClassNotFoundException {
        String problemName = "eil101.tsp";
        TSP problem = new TSP("Permutation", problemName);
        ssGA algorithm = new ssGA(problem);
        algorithm.setInputParameter("populationSize", 100);
        algorithm.setInputParameter("maxEvaluations", 2000000);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", 0.95);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("TwoPointsCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", 0.2);
        Mutation mutation = MutationFactory.getMutationOperator("SwapMutation", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("BinaryTournament", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        System.out.println("Total time of execution: " + estimatedTime);
        System.out.println("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        System.out.println("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
    }
}

