/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.geneticAlgorithm;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.operators.selection.BestSolutionSelection;
import jmetal.util.JMException;
import jmetal.util.Neighborhood;
import jmetal.util.comparators.ObjectiveComparator;

public class scGA
extends Algorithm {
    public scGA(Problem problem) {
        super(problem);
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        Operator mutationOperator = null;
        Operator crossoverOperator = null;
        Operator selectionOperator = null;
        ObjectiveComparator comparator = new ObjectiveComparator(0);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("comparator", comparator);
        BestSolutionSelection findBestSolution = new BestSolutionSelection(parameters);
        int populationSize = (Integer)this.getInputParameter("populationSize");
        int maxEvaluations = (Integer)this.getInputParameter("maxEvaluations");
        mutationOperator = (Operator)this.operators_.get("mutation");
        crossoverOperator = (Operator)this.operators_.get("crossover");
        selectionOperator = (Operator)this.operators_.get("selection");
        int evaluations = 0;
        Neighborhood neighborhood = new Neighborhood(populationSize);
        SolutionSet[] neighbors = new SolutionSet[populationSize];
        SolutionSet population = new SolutionSet(populationSize);
        for (int i = 0; i < populationSize; ++i) {
            Solution solution = new Solution(this.problem_);
            this.problem_.evaluate(solution);
            population.add(solution);
            solution.setLocation(i);
            ++evaluations;
        }
        boolean solutionFound = false;
        while (evaluations < maxEvaluations && !solutionFound) {
            SolutionSet tempPopulation = new SolutionSet(populationSize);
            for (int ind = 0; ind < population.size(); ++ind) {
                Solution individual = new Solution(population.get(ind));
                Solution[] parents = new Solution[2];
                Solution[] offSpring = null;
                neighbors[ind] = neighborhood.getEightNeighbors(population, ind);
                neighbors[ind].add(individual);
                parents[0] = (Solution)selectionOperator.execute(neighbors[ind]);
                parents[1] = (Solution)selectionOperator.execute(neighbors[ind]);
                offSpring = crossoverOperator != null ? (Solution[])crossoverOperator.execute(parents) : new Solution[]{new Solution(parents[0])};
                mutationOperator.execute(offSpring[0]);
                this.problem_.evaluate(offSpring[0]);
                ++evaluations;
                if (comparator.compare(individual, offSpring[0]) < 0) {
                    tempPopulation.add(individual);
                    continue;
                }
                tempPopulation.add(offSpring[0]);
            }
            population = tempPopulation;
        }
        SolutionSet resultPopulation = new SolutionSet(1);
        resultPopulation.add(population.best(comparator));
        return resultPopulation;
    }
}

