/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.particleSwarmOptimization;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.operators.selection.BestSolutionSelection;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.comparators.ObjectiveComparator;
import jmetal.util.wrapper.XReal;

public class PSO
extends Algorithm {
    private int particlesSize_;
    private int maxIterations_;
    private int iteration_;
    private SolutionSet particles_;
    private Solution[] localBest_;
    private Solution globalBest_;
    private double[][] speed_;
    private Operator polynomialMutation_;
    int evaluations_;
    Comparator comparator_ = new ObjectiveComparator(0);
    Operator findBestSolution_;
    double r1Max_ = 1.0;
    double r1Min_ = 0.0;
    double r2Max_ = 1.0;
    double r2Min_ = 0.0;
    double C1Max_ = 1.5;
    double C1Min_ = 1.5;
    double C2Max_ = 1.5;
    double C2Min_ = 1.5;
    double WMax_ = 0.9;
    double WMin_ = 0.1;
    double ChVel1_ = 1.0;
    double ChVel2_ = 1.0;
    private SolutionSet trueFront_;
    private double[] deltaMax_;
    private double[] deltaMin_;
    boolean success_;

    public PSO(Problem problem) {
        super(problem);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("comparator", this.comparator_);
        this.findBestSolution_ = new BestSolutionSelection(parameters);
        this.evaluations_ = 0;
    }

    public void initParams() {
        this.particlesSize_ = (Integer)this.getInputParameter("swarmSize");
        this.maxIterations_ = (Integer)this.getInputParameter("maxIterations");
        this.polynomialMutation_ = (Operator)this.operators_.get("mutation");
        this.iteration_ = 0;
        this.success_ = false;
        this.particles_ = new SolutionSet(this.particlesSize_);
        this.localBest_ = new Solution[this.particlesSize_];
        this.speed_ = new double[this.particlesSize_][this.problem_.getNumberOfVariables()];
        this.deltaMax_ = new double[this.problem_.getNumberOfVariables()];
        this.deltaMin_ = new double[this.problem_.getNumberOfVariables()];
        for (int i = 0; i < this.problem_.getNumberOfVariables(); ++i) {
            this.deltaMax_[i] = (this.problem_.getUpperLimit(i) - this.problem_.getLowerLimit(i)) / 2.0;
            this.deltaMin_[i] = -this.deltaMax_[i];
        }
    }

    private double inertiaWeight(int iter, int miter, double wmax, double wmin) {
        return wmax - (wmax - wmin) * (double)iter / (double)miter;
    }

    private double constrictionCoefficient(double c1, double c2) {
        double rho = c1 + c2;
        if (rho <= 4.0) {
            return 1.0;
        }
        return 2.0 / Math.abs(2.0 - rho - Math.sqrt(Math.pow(rho, 2.0) - 4.0 * rho));
    }

    private double velocityConstriction(double v, double[] deltaMax, double[] deltaMin, int variableIndex, int particleIndex) throws IOException {
        return v;
    }

    private void computeSpeed(int iter, int miter) throws JMException, IOException {
        XReal bestGlobal = new XReal(this.globalBest_);
        for (int i = 0; i < this.particlesSize_; ++i) {
            XReal particle = new XReal(this.particles_.get(i));
            XReal bestParticle = new XReal(this.localBest_[i]);
            this.C1Max_ = 2.5;
            this.C1Min_ = 1.5;
            this.C2Max_ = 2.5;
            this.C2Min_ = 1.5;
            double r1 = PseudoRandom.randDouble(this.r1Min_, this.r1Max_);
            double r2 = PseudoRandom.randDouble(this.r2Min_, this.r2Max_);
            double C1 = PseudoRandom.randDouble(this.C1Min_, this.C1Max_);
            double C2 = PseudoRandom.randDouble(this.C2Min_, this.C2Max_);
            this.WMax_ = 0.9;
            this.WMin_ = 0.9;
            this.ChVel1_ = 1.0;
            this.ChVel2_ = 1.0;
            C1 = 2.5;
            C2 = 1.5;
            double wmax = this.WMax_;
            double wmin = this.WMin_;
            C1 = 1.5;
            C2 = 1.5;
            double W = 0.9;
            for (int var = 0; var < particle.size(); ++var) {
                this.speed_[i][var] = this.inertiaWeight(iter, miter, wmax, wmin) * this.speed_[i][var] + C1 * r1 * (bestParticle.getValue(var) - particle.getValue(var)) + C2 * r2 * (bestGlobal.getValue(var) - particle.getValue(var));
            }
        }
    }

    private void computeNewPositions() throws JMException {
        for (int i = 0; i < this.particlesSize_; ++i) {
            XReal particle = new XReal(this.particles_.get(i));
            for (int var = 0; var < particle.size(); ++var) {
                particle.setValue(var, particle.getValue(var) + this.speed_[i][var]);
                if (particle.getValue(var) < this.problem_.getLowerLimit(var)) {
                    particle.setValue(var, this.problem_.getLowerLimit(var));
                    this.speed_[i][var] = this.speed_[i][var] * this.ChVel1_;
                }
                if (!(particle.getValue(var) > this.problem_.getUpperLimit(var))) continue;
                particle.setValue(var, this.problem_.getUpperLimit(var));
                this.speed_[i][var] = this.speed_[i][var] * this.ChVel2_;
            }
        }
    }

    private void mopsoMutation(int actualIteration, int totalIterations) throws JMException {
        for (int i = 0; i < this.particles_.size(); ++i) {
            if (i % 6 != 0) continue;
            this.polynomialMutation_.execute(this.particles_.get(i));
        }
    }

    @Override
    public SolutionSet execute() throws JMException, ClassNotFoundException {
        int i;
        this.initParams();
        this.success_ = false;
        this.globalBest_ = null;
        for (i = 0; i < this.particlesSize_; ++i) {
            Solution particle = new Solution(this.problem_);
            this.problem_.evaluate(particle);
            ++this.evaluations_;
            this.particles_.add(particle);
            if (this.globalBest_ != null && !(particle.getObjective(0) < this.globalBest_.getObjective(0))) continue;
            this.globalBest_ = new Solution(particle);
        }
        for (i = 0; i < this.particlesSize_; ++i) {
            for (int j = 0; j < this.problem_.getNumberOfVariables(); ++j) {
                this.speed_[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.particles_.size(); ++i) {
            Solution particle;
            this.localBest_[i] = particle = new Solution(this.particles_.get(i));
        }
        while (this.iteration_ < this.maxIterations_) {
            Solution particle;
            int i2;
            int bestIndividual = (Integer)this.findBestSolution_.execute(this.particles_);
            try {
                this.computeSpeed(this.iteration_, this.maxIterations_);
            }
            catch (IOException ex) {
                Logger.getLogger(PSO.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.computeNewPositions();
            for (i2 = 0; i2 < this.particles_.size(); ++i2) {
                particle = this.particles_.get(i2);
                this.problem_.evaluate(particle);
                ++this.evaluations_;
            }
            for (i2 = 0; i2 < this.particles_.size(); ++i2) {
                if (this.particles_.get(i2).getObjective(0) < this.localBest_[i2].getObjective(0)) {
                    this.localBest_[i2] = particle = new Solution(this.particles_.get(i2));
                }
                if (!(this.particles_.get(i2).getObjective(0) < this.globalBest_.getObjective(0))) continue;
                this.globalBest_ = particle = new Solution(this.particles_.get(i2));
            }
            ++this.iteration_;
        }
        SolutionSet resultPopulation = new SolutionSet(1);
        resultPopulation.add(this.particles_.get((Integer)this.findBestSolution_.execute(this.particles_)));
        return resultPopulation;
    }
}

