/*
 * Decompiled with CFR 0.152.
 */
package jmetal.metaheuristics.singleObjective.particleSwarmOptimization;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.core.SolutionSet;
import jmetal.metaheuristics.singleObjective.particleSwarmOptimization.PSO;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.singleObjective.Sphere;
import jmetal.util.Configuration;
import jmetal.util.JMException;

public class PSO_main {
    public static Logger logger_;
    public static FileHandler fileHandler_;

    public static void main(String[] args) throws JMException, IOException, ClassNotFoundException {
        logger_ = Configuration.logger_;
        fileHandler_ = new FileHandler("PSO_main.log");
        logger_.addHandler(fileHandler_);
        Sphere problem = new Sphere("Real", 20);
        PSO algorithm = new PSO(problem);
        algorithm.setInputParameter("swarmSize", 50);
        algorithm.setInputParameter("maxIterations", 5000);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("probability", 1.0 / (double)problem.getNumberOfVariables());
        parameters.put("distributionIndex", 20.0);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("mutation", mutation);
        long initTime = System.currentTimeMillis();
        SolutionSet population = ((Algorithm)algorithm).execute();
        long estimatedTime = System.currentTimeMillis() - initTime;
        logger_.info("Total execution time: " + estimatedTime + "ms");
        logger_.info("Objectives values have been writen to file FUN");
        population.printObjectivesToFile("FUN");
        logger_.info("Variables values have been writen to file VAR");
        population.printVariablesToFile("VAR");
    }
}

