/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.crossover;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.operators.crossover.Crossover;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.wrapper.XReal;

public class BLXAlphaCrossover
extends Crossover {
    protected static final double DEFAULT_ALPHA = 0.5;
    private double alpha_ = 0.5;
    private Double crossoverProbability_ = null;
    private static List VALID_TYPES = Arrays.asList(RealSolutionType.class, ArrayRealSolutionType.class);

    public BLXAlphaCrossover(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("probability") != null) {
            this.crossoverProbability_ = (Double)parameters.get("probability");
        }
        if (parameters.get("alpha") != null) {
            this.alpha_ = (Double)parameters.get("alpha");
        }
    }

    public Solution[] doCrossover(double probability, Solution parent1, Solution parent2) throws JMException {
        Solution[] offSpring = new Solution[]{new Solution(parent1), new Solution(parent2)};
        XReal x1 = new XReal(parent1);
        XReal x2 = new XReal(parent2);
        XReal offs1 = new XReal(offSpring[0]);
        XReal offs2 = new XReal(offSpring[1]);
        int numberOfVariables = x1.getNumberOfDecisionVariables();
        if (PseudoRandom.randDouble() <= probability) {
            for (int i = 0; i < numberOfVariables; ++i) {
                double min;
                double max;
                double upperValue = x1.getUpperBound(i);
                double lowerValue = x1.getLowerBound(i);
                double valueX1 = x1.getValue(i);
                double valueX2 = x2.getValue(i);
                if (valueX2 > valueX1) {
                    max = valueX2;
                    min = valueX1;
                } else {
                    max = valueX1;
                    min = valueX2;
                }
                double range = max - min;
                double minRange = min - range * this.alpha_;
                double maxRange = max + range * this.alpha_;
                double random = PseudoRandom.randDouble();
                double valueY1 = minRange + random * (maxRange - minRange);
                random = PseudoRandom.randDouble();
                double valueY2 = minRange + random * (maxRange - minRange);
                if (valueY1 < lowerValue) {
                    offs1.setValue(i, lowerValue);
                } else if (valueY1 > upperValue) {
                    offs1.setValue(i, upperValue);
                } else {
                    offs1.setValue(i, valueY1);
                }
                if (valueY2 < lowerValue) {
                    offs2.setValue(i, lowerValue);
                    continue;
                }
                if (valueY2 > upperValue) {
                    offs2.setValue(i, upperValue);
                    continue;
                }
                offs2.setValue(i, valueY2);
            }
        }
        return offSpring;
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution[] parents = (Solution[])object;
        if (parents.length != 2) {
            Configuration.logger_.severe("BLXAlphaCrossover.execute: operator needs two parents");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        if (!VALID_TYPES.contains(parents[0].getType().getClass()) || !VALID_TYPES.contains(parents[1].getType().getClass())) {
            Configuration.logger_.severe("BLXAlphaCrossover.execute: the solutions type " + parents[0].getType() + " is not allowed with this operator");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        Solution[] offSpring = this.doCrossover(this.crossoverProbability_, parents[0], parents[1]);
        return offSpring;
    }
}

