/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.crossover;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.operators.crossover.Crossover;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.wrapper.XReal;

public class DifferentialEvolutionCrossover
extends Crossover {
    public static final double DEFAULT_CR = 0.5;
    private static final double DEFAULT_F = 0.5;
    public static final double DEFAULT_K = 0.5;
    private static final String DEFAULT_DE_VARIANT = "rand/1/bin";
    private static List VALID_TYPES = Arrays.asList(RealSolutionType.class, ArrayRealSolutionType.class);
    public double CR_ = 0.5;
    public double F_ = 0.5;
    public double K_ = 0.5;
    private String DE_Variant_ = "rand/1/bin";

    public DifferentialEvolutionCrossover(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("CR") != null) {
            this.CR_ = (Double)parameters.get("CR");
        }
        if (parameters.get("F") != null) {
            this.F_ = (Double)parameters.get("F");
        }
        if (parameters.get("K") != null) {
            this.K_ = (Double)parameters.get("K");
        }
        if (parameters.get("DE_VARIANT") != null) {
            this.DE_Variant_ = (String)parameters.get("DE_VARIANT");
        }
    }

    @Override
    public Object execute(Object object) throws JMException {
        Object[] parameters = (Object[])object;
        Solution current = (Solution)parameters[0];
        Solution[] parent = (Solution[])parameters[1];
        if (!(VALID_TYPES.contains(parent[0].getType().getClass()) && VALID_TYPES.contains(parent[1].getType().getClass()) && VALID_TYPES.contains(parent[2].getType().getClass()))) {
            Configuration.logger_.severe("DifferentialEvolutionCrossover.execute:  the solutions are not of the right type. The type should be 'Real' or 'ArrayReal', but " + parent[0].getType() + " and " + parent[1].getType() + " and " + parent[2].getType() + " are obtained");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        Solution child = new Solution(current);
        XReal xParent0 = new XReal(parent[0]);
        XReal xParent1 = new XReal(parent[1]);
        XReal xParent2 = new XReal(parent[2]);
        XReal xCurrent = new XReal(current);
        XReal xChild = new XReal(child);
        int numberOfVariables = xParent0.getNumberOfDecisionVariables();
        int jrand = PseudoRandom.randInt(0, numberOfVariables - 1);
        if (this.DE_Variant_.compareTo(DEFAULT_DE_VARIANT) == 0 || this.DE_Variant_.compareTo("best/1/bin") == 0) {
            for (int j = 0; j < numberOfVariables; ++j) {
                double value;
                if (PseudoRandom.randDouble(0.0, 1.0) < this.CR_ || j == jrand) {
                    value = xParent2.getValue(j) + this.F_ * (xParent0.getValue(j) - xParent1.getValue(j));
                    if (value < xChild.getLowerBound(j)) {
                        value = xChild.getLowerBound(j);
                    }
                    if (value > xChild.getUpperBound(j)) {
                        value = xChild.getUpperBound(j);
                    }
                    xChild.setValue(j, value);
                    continue;
                }
                value = xCurrent.getValue(j);
                xChild.setValue(j, value);
            }
        } else if (this.DE_Variant_.compareTo("rand/1/exp") == 0 || this.DE_Variant_.compareTo("best/1/exp") == 0) {
            for (int j = 0; j < numberOfVariables; ++j) {
                double value;
                if (PseudoRandom.randDouble(0.0, 1.0) < this.CR_ || j == jrand) {
                    value = xParent2.getValue(j) + this.F_ * (xParent0.getValue(j) - xParent1.getValue(j));
                    if (value < xChild.getLowerBound(j)) {
                        value = xChild.getLowerBound(j);
                    }
                    if (value > xChild.getUpperBound(j)) {
                        value = xChild.getUpperBound(j);
                    }
                    xChild.setValue(j, value);
                    continue;
                }
                this.CR_ = 0.0;
                value = xCurrent.getValue(j);
                xChild.setValue(j, value);
            }
        } else if (this.DE_Variant_.compareTo("current-to-rand/1") == 0 || this.DE_Variant_.compareTo("current-to-best/1") == 0) {
            for (int j = 0; j < numberOfVariables; ++j) {
                double value = xCurrent.getValue(j) + this.K_ * (xParent2.getValue(j) - xCurrent.getValue(j)) + this.F_ * (xParent0.getValue(j) - xParent1.getValue(j));
                if (value < xChild.getLowerBound(j)) {
                    value = xChild.getLowerBound(j);
                }
                if (value > xChild.getUpperBound(j)) {
                    value = xChild.getUpperBound(j);
                }
                xChild.setValue(j, value);
            }
        } else if (this.DE_Variant_.compareTo("current-to-rand/1/bin") == 0 || this.DE_Variant_.compareTo("current-to-best/1/bin") == 0) {
            for (int j = 0; j < numberOfVariables; ++j) {
                double value;
                if (PseudoRandom.randDouble(0.0, 1.0) < this.CR_ || j == jrand) {
                    value = xCurrent.getValue(j) + this.K_ * (xParent2.getValue(j) - xCurrent.getValue(j)) + this.F_ * (xParent0.getValue(j) - xParent1.getValue(j));
                    if (value < xChild.getLowerBound(j)) {
                        value = xChild.getLowerBound(j);
                    }
                    if (value > xChild.getUpperBound(j)) {
                        value = xChild.getUpperBound(j);
                    }
                    xChild.setValue(j, value);
                    continue;
                }
                value = xCurrent.getValue(j);
                xChild.setValue(j, value);
            }
        } else if (this.DE_Variant_.compareTo("current-to-rand/1/exp") == 0 || this.DE_Variant_.compareTo("current-to-best/1/exp") == 0) {
            for (int j = 0; j < numberOfVariables; ++j) {
                double value;
                if (PseudoRandom.randDouble(0.0, 1.0) < this.CR_ || j == jrand) {
                    value = xCurrent.getValue(j) + this.K_ * (xParent2.getValue(j) - xCurrent.getValue(j)) + this.F_ * (xParent0.getValue(j) - xParent1.getValue(j));
                    if (value < xChild.getLowerBound(j)) {
                        value = xChild.getLowerBound(j);
                    }
                    if (value > xChild.getUpperBound(j)) {
                        value = xChild.getUpperBound(j);
                    }
                    xChild.setValue(j, value);
                    continue;
                }
                this.CR_ = 0.0;
                value = xCurrent.getValue(j);
                xChild.setValue(j, value);
            }
        } else {
            Configuration.logger_.severe("DifferentialEvolutionCrossover.execute:  unknown DE variant (" + this.DE_Variant_ + ")");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        return child;
    }
}

