/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.crossover;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.PermutationSolutionType;
import jmetal.encodings.variable.Permutation;
import jmetal.operators.crossover.Crossover;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class PMXCrossover
extends Crossover {
    private static List VALID_TYPES = Arrays.asList(PermutationSolutionType.class);
    private Double crossoverProbability_ = null;

    public PMXCrossover(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("probability") != null) {
            this.crossoverProbability_ = (Double)parameters.get("probability");
        }
    }

    public Solution[] doCrossover(double probability, Solution parent1, Solution parent2) throws JMException {
        Solution[] offspring = new Solution[]{new Solution(parent1), new Solution(parent2)};
        int permutationLength = ((Permutation)parent1.getDecisionVariables()[0]).getLength();
        int[] parent1Vector = ((Permutation)parent1.getDecisionVariables()[0]).vector_;
        int[] parent2Vector = ((Permutation)parent2.getDecisionVariables()[0]).vector_;
        int[] offspring1Vector = ((Permutation)offspring[0].getDecisionVariables()[0]).vector_;
        int[] offspring2Vector = ((Permutation)offspring[1].getDecisionVariables()[0]).vector_;
        if (PseudoRandom.randDouble() < probability) {
            int i;
            int cuttingPoint1 = PseudoRandom.randInt(0, permutationLength - 1);
            int cuttingPoint2 = PseudoRandom.randInt(0, permutationLength - 1);
            while (cuttingPoint2 == cuttingPoint1) {
                cuttingPoint2 = PseudoRandom.randInt(0, permutationLength - 1);
            }
            if (cuttingPoint1 > cuttingPoint2) {
                int swap = cuttingPoint1;
                cuttingPoint1 = cuttingPoint2;
                cuttingPoint2 = swap;
            }
            int[] replacement1 = new int[permutationLength];
            int[] replacement2 = new int[permutationLength];
            for (i = 0; i < permutationLength; ++i) {
                replacement2[i] = -1;
                replacement1[i] = -1;
            }
            for (i = cuttingPoint1; i <= cuttingPoint2; ++i) {
                offspring1Vector[i] = parent2Vector[i];
                offspring2Vector[i] = parent1Vector[i];
                replacement1[parent2Vector[i]] = parent1Vector[i];
                replacement2[parent1Vector[i]] = parent2Vector[i];
            }
            for (i = 0; i < permutationLength; ++i) {
                if (i >= cuttingPoint1 && i <= cuttingPoint2) continue;
                int n1 = parent1Vector[i];
                int m1 = replacement1[n1];
                int n2 = parent2Vector[i];
                int m2 = replacement2[n2];
                while (m1 != -1) {
                    n1 = m1;
                    m1 = replacement1[m1];
                }
                while (m2 != -1) {
                    n2 = m2;
                    m2 = replacement2[m2];
                }
                offspring1Vector[i] = n1;
                offspring2Vector[i] = n2;
            }
        }
        return offspring;
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution[] parents = (Solution[])object;
        Double crossoverProbability = null;
        if (!VALID_TYPES.contains(parents[0].getType().getClass()) || !VALID_TYPES.contains(parents[1].getType().getClass())) {
            Configuration.logger_.severe("PMCCrossover.execute: the solutions are not of the right type. The type should be 'Permutation', but " + parents[0].getType() + " and " + parents[1].getType() + " are obtained");
        }
        crossoverProbability = (Double)this.getParameter("probability");
        if (parents.length < 2) {
            Configuration.logger_.severe("PMXCrossover.execute: operator needs two parents");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        Solution[] offspring = this.doCrossover(crossoverProbability, parents[0], parents[1]);
        return offspring;
    }
}

