/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.crossover;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.PermutationSolutionType;
import jmetal.encodings.variable.Permutation;
import jmetal.operators.crossover.Crossover;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class TwoPointsCrossover
extends Crossover {
    private static List VALID_TYPES = Arrays.asList(PermutationSolutionType.class);
    private Double crossoverProbability_ = null;

    public TwoPointsCrossover(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("probability") != null) {
            this.crossoverProbability_ = (Double)parameters.get("probability");
        }
    }

    public Solution[] doCrossover(double probability, Solution parent1, Solution parent2) throws JMException {
        Solution[] offspring = new Solution[]{new Solution(parent1), new Solution(parent2)};
        if (parent1.getType().getClass() == PermutationSolutionType.class) {
            if (PseudoRandom.randDouble() < probability) {
                int k;
                int temp;
                boolean exist;
                int j;
                int permutationLength = ((Permutation)parent1.getDecisionVariables()[0]).getLength();
                int[] parent1Vector = ((Permutation)parent1.getDecisionVariables()[0]).vector_;
                int[] parent2Vector = ((Permutation)parent2.getDecisionVariables()[0]).vector_;
                int[] offspring1Vector = ((Permutation)offspring[0].getDecisionVariables()[0]).vector_;
                int[] offspring2Vector = ((Permutation)offspring[1].getDecisionVariables()[0]).vector_;
                int crosspoint1 = PseudoRandom.randInt(0, permutationLength - 1);
                int crosspoint2 = PseudoRandom.randInt(0, permutationLength - 1);
                while (crosspoint2 == crosspoint1) {
                    crosspoint2 = PseudoRandom.randInt(0, permutationLength - 1);
                }
                if (crosspoint1 > crosspoint2) {
                    int swap = crosspoint1;
                    crosspoint1 = crosspoint2;
                    crosspoint2 = swap;
                }
                int m = 0;
                for (j = 0; j < permutationLength; ++j) {
                    exist = false;
                    temp = parent2Vector[j];
                    for (k = crosspoint1; k <= crosspoint2; ++k) {
                        if (temp != offspring1Vector[k]) continue;
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                    if (m == crosspoint1) {
                        m = crosspoint2 + 1;
                    }
                    offspring1Vector[m++] = temp;
                }
                m = 0;
                for (j = 0; j < permutationLength; ++j) {
                    exist = false;
                    temp = parent1Vector[j];
                    for (k = crosspoint1; k <= crosspoint2; ++k) {
                        if (temp != offspring2Vector[k]) continue;
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                    if (m == crosspoint1) {
                        m = crosspoint2 + 1;
                    }
                    offspring2Vector[m++] = temp;
                }
            }
        } else {
            Configuration.logger_.severe("TwoPointsCrossover.doCrossover: invalid type" + parent1.getDecisionVariables()[0].getVariableType());
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".doCrossover()");
        }
        return offspring;
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution[] parents = (Solution[])object;
        if (!VALID_TYPES.contains(parents[0].getType().getClass()) || !VALID_TYPES.contains(parents[1].getType().getClass())) {
            Configuration.logger_.severe("TwoPointsCrossover.execute: the solutions are not of the right type. The type should be 'Permutation', but " + parents[0].getType() + " and " + parents[1].getType() + " are obtained");
        }
        Double crossoverProbability = (Double)this.getParameter("probability");
        if (parents.length < 2) {
            Configuration.logger_.severe("TwoPointsCrossover.execute: operator needs two parents");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        Solution[] offspring = this.doCrossover(this.crossoverProbability_, parents[0], parents[1]);
        return offspring;
    }
}

