/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.localSearch;

import java.util.Comparator;
import java.util.HashMap;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.operators.localSearch.LocalSearch;
import jmetal.operators.mutation.Mutation;
import jmetal.util.JMException;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.comparators.OverallConstraintViolationComparator;

public class MutationLocalSearch
extends LocalSearch {
    private Problem problem_;
    private SolutionSet archive_;
    private int improvementRounds_;
    private Comparator constraintComparator_;
    private Comparator dominanceComparator_;
    private Operator mutationOperator_;
    int evaluations_;

    public MutationLocalSearch(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("problem") != null) {
            this.problem_ = (Problem)parameters.get("problem");
        }
        if (parameters.get("improvementRounds") != null) {
            this.improvementRounds_ = (Integer)parameters.get("improvementRounds");
        }
        if (parameters.get("mutation") != null) {
            this.mutationOperator_ = (Mutation)parameters.get("mutation");
        }
        this.evaluations_ = 0;
        this.archive_ = null;
        this.dominanceComparator_ = new DominanceComparator();
        this.constraintComparator_ = new OverallConstraintViolationComparator();
    }

    @Override
    public Object execute(Object object) throws JMException {
        int i = 0;
        int best = 0;
        this.evaluations_ = 0;
        Solution solution = (Solution)object;
        int rounds = this.improvementRounds_;
        this.archive_ = (SolutionSet)this.getParameter("archive");
        if (rounds <= 0) {
            return new Solution(solution);
        }
        do {
            ++i;
            Solution mutatedSolution = new Solution(solution);
            this.mutationOperator_.execute(mutatedSolution);
            if (this.problem_.getNumberOfConstraints() > 0) {
                this.problem_.evaluateConstraints(mutatedSolution);
                best = this.constraintComparator_.compare(mutatedSolution, solution);
                if (best == 0) {
                    this.problem_.evaluate(mutatedSolution);
                    ++this.evaluations_;
                    best = this.dominanceComparator_.compare(mutatedSolution, solution);
                } else if (best == -1) {
                    this.problem_.evaluate(mutatedSolution);
                    ++this.evaluations_;
                }
            } else {
                this.problem_.evaluate(mutatedSolution);
                ++this.evaluations_;
                best = this.dominanceComparator_.compare(mutatedSolution, solution);
            }
            if (best == -1) {
                solution = mutatedSolution;
                continue;
            }
            if (best == 1 || this.archive_ == null) continue;
            this.archive_.add(mutatedSolution);
        } while (i < rounds);
        return new Solution(solution);
    }

    @Override
    public int getEvaluations() {
        return this.evaluations_;
    }
}

