/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.mutation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.BinarySolutionType;
import jmetal.encodings.solutionType.IntSolutionType;
import jmetal.encodings.variable.Binary;
import jmetal.operators.mutation.Mutation;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class BitFlipMutation
extends Mutation {
    private static List VALID_TYPES = Arrays.asList(BinarySolutionType.class, BinaryRealSolutionType.class, IntSolutionType.class);
    private Double mutationProbability_ = null;

    public BitFlipMutation(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("probability") != null) {
            this.mutationProbability_ = (Double)parameters.get("probability");
        }
    }

    public void doMutation(double probability, Solution solution) throws JMException {
        try {
            if (solution.getType().getClass() == BinarySolutionType.class || solution.getType().getClass() == BinaryRealSolutionType.class) {
                int i;
                for (i = 0; i < solution.getDecisionVariables().length; ++i) {
                    for (int j = 0; j < ((Binary)solution.getDecisionVariables()[i]).getNumberOfBits(); ++j) {
                        if (!(PseudoRandom.randDouble() < probability)) continue;
                        ((Binary)solution.getDecisionVariables()[i]).bits_.flip(j);
                    }
                }
                for (i = 0; i < solution.getDecisionVariables().length; ++i) {
                    ((Binary)solution.getDecisionVariables()[i]).decode();
                }
            } else {
                for (int i = 0; i < solution.getDecisionVariables().length; ++i) {
                    if (!(PseudoRandom.randDouble() < probability)) continue;
                    int value = PseudoRandom.randInt((int)solution.getDecisionVariables()[i].getLowerBound(), (int)solution.getDecisionVariables()[i].getUpperBound());
                    solution.getDecisionVariables()[i].setValue(value);
                }
            }
        }
        catch (ClassCastException e1) {
            Configuration.logger_.severe("BitFlipMutation.doMutation: ClassCastException error" + e1.getMessage());
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".doMutation()");
        }
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution solution = (Solution)object;
        if (!VALID_TYPES.contains(solution.getType().getClass())) {
            Configuration.logger_.severe("BitFlipMutation.execute: the solution is not of the right type. The type should be 'Binary', 'BinaryReal' or 'Int', but " + solution.getType() + " is obtained");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        this.doMutation(this.mutationProbability_, solution);
        return solution;
    }
}

