/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.mutation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.operators.mutation.Mutation;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.wrapper.XReal;

public class NonUniformMutation
extends Mutation {
    private static List VALID_TYPES = Arrays.asList(RealSolutionType.class, ArrayRealSolutionType.class);
    private Double perturbation_ = null;
    private Integer maxIterations_ = null;
    private Integer currentIteration_ = null;
    private Double mutationProbability_ = null;

    public NonUniformMutation(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("probability") != null) {
            this.mutationProbability_ = (Double)parameters.get("probability");
        }
        if (parameters.get("perturbation") != null) {
            this.perturbation_ = (Double)parameters.get("perturbation");
        }
        if (parameters.get("maxIterations") != null) {
            this.maxIterations_ = (Integer)parameters.get("maxIterations");
        }
    }

    public void doMutation(double probability, Solution solution) throws JMException {
        XReal x = new XReal(solution);
        for (int var = 0; var < solution.getDecisionVariables().length; ++var) {
            double tmp;
            if (!(PseudoRandom.randDouble() < probability)) continue;
            double rand = PseudoRandom.randDouble();
            if (rand <= 0.5) {
                tmp = this.delta(x.getUpperBound(var) - x.getValue(var), this.perturbation_);
                tmp += x.getValue(var);
            } else {
                tmp = this.delta(x.getLowerBound(var) - x.getValue(var), this.perturbation_);
                tmp += x.getValue(var);
            }
            if (tmp < x.getLowerBound(var)) {
                tmp = x.getLowerBound(var);
            } else if (tmp > x.getUpperBound(var)) {
                tmp = x.getUpperBound(var);
            }
            x.setValue(var, tmp);
        }
    }

    private double delta(double y, double bMutationParameter) {
        double rand = PseudoRandom.randDouble();
        int it = this.currentIteration_;
        int maxIt = this.maxIterations_;
        return y * (1.0 - Math.pow(rand, Math.pow(1.0 - (double)it / (double)maxIt, bMutationParameter)));
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution solution = (Solution)object;
        if (!VALID_TYPES.contains(solution.getType().getClass())) {
            Configuration.logger_.severe("NonUniformMutation.execute: the solution " + solution.getType() + "is not of the right type");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        if (this.getParameter("currentIteration") != null) {
            this.currentIteration_ = (Integer)this.getParameter("currentIteration");
        }
        this.doMutation(this.mutationProbability_, solution);
        return solution;
    }
}

