/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.mutation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.operators.mutation.Mutation;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.wrapper.XReal;

public class PolynomialMutation
extends Mutation {
    public static final double ETA_M_DEFAULT_ = 20.0;
    public double eta_m_ = 20.0;
    private Double mutationProbability_ = null;
    private Double distributionIndex_ = this.eta_m_;
    private static List VALID_TYPES = Arrays.asList(RealSolutionType.class, ArrayRealSolutionType.class);

    public PolynomialMutation(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("probability") != null) {
            this.mutationProbability_ = (Double)parameters.get("probability");
        }
        if (parameters.get("distributionIndex") != null) {
            this.distributionIndex_ = (Double)parameters.get("distributionIndex");
        }
    }

    public void doMutation(double probability, Solution solution) throws JMException {
        XReal x = new XReal(solution);
        for (int var = 0; var < solution.numberOfVariables(); ++var) {
            double deltaq;
            double val;
            double xy;
            if (!(PseudoRandom.randDouble() <= probability)) continue;
            double y = x.getValue(var);
            double yl = x.getLowerBound(var);
            double yu = x.getUpperBound(var);
            double delta1 = (y - yl) / (yu - yl);
            double delta2 = (yu - y) / (yu - yl);
            double rnd = PseudoRandom.randDouble();
            double mut_pow = 1.0 / (this.eta_m_ + 1.0);
            if (rnd <= 0.5) {
                xy = 1.0 - delta1;
                val = 2.0 * rnd + (1.0 - 2.0 * rnd) * Math.pow(xy, this.eta_m_ + 1.0);
                deltaq = Math.pow(val, mut_pow) - 1.0;
            } else {
                xy = 1.0 - delta2;
                val = 2.0 * (1.0 - rnd) + 2.0 * (rnd - 0.5) * Math.pow(xy, this.eta_m_ + 1.0);
                deltaq = 1.0 - Math.pow(val, mut_pow);
            }
            y += deltaq * (yu - yl);
            if (y < yl) {
                y = yl;
            }
            if (y > yu) {
                y = yu;
            }
            x.setValue(var, y);
        }
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution solution = (Solution)object;
        if (!VALID_TYPES.contains(solution.getType().getClass())) {
            Configuration.logger_.severe("PolynomialMutation.execute: the solution type " + solution.getType() + " is not allowed with this operator");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        this.doMutation(this.mutationProbability_, solution);
        return solution;
    }
}

