/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.mutation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.PermutationSolutionType;
import jmetal.encodings.variable.Permutation;
import jmetal.operators.mutation.Mutation;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class SwapMutation
extends Mutation {
    private static List VALID_TYPES = Arrays.asList(PermutationSolutionType.class);
    private Double mutationProbability_ = null;

    public SwapMutation(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("probability") != null) {
            this.mutationProbability_ = (Double)parameters.get("probability");
        }
    }

    public void doMutation(double probability, Solution solution) throws JMException {
        if (solution.getType().getClass() == PermutationSolutionType.class) {
            int permutationLength = ((Permutation)solution.getDecisionVariables()[0]).getLength();
            int[] permutation = ((Permutation)solution.getDecisionVariables()[0]).vector_;
            if (PseudoRandom.randDouble() < probability) {
                int pos1 = PseudoRandom.randInt(0, permutationLength - 1);
                int pos2 = PseudoRandom.randInt(0, permutationLength - 1);
                while (pos1 == pos2) {
                    if (pos1 == permutationLength - 1) {
                        pos2 = PseudoRandom.randInt(0, permutationLength - 2);
                        continue;
                    }
                    pos2 = PseudoRandom.randInt(pos1, permutationLength - 1);
                }
                int temp = permutation[pos1];
                permutation[pos1] = permutation[pos2];
                permutation[pos2] = temp;
            }
        } else {
            Configuration.logger_.severe("SwapMutation.doMutation: invalid type. " + solution.getDecisionVariables()[0].getVariableType());
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".doMutation()");
        }
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution solution = (Solution)object;
        if (!VALID_TYPES.contains(solution.getType().getClass())) {
            Configuration.logger_.severe("SwapMutation.execute: the solution is not of the right type. The type should be 'Binary', 'BinaryReal' or 'Int', but " + solution.getType() + " is obtained");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        this.doMutation(this.mutationProbability_, solution);
        return solution;
    }
}

