/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.mutation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.operators.mutation.Mutation;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.wrapper.XReal;

public class UniformMutation
extends Mutation {
    private static List VALID_TYPES = Arrays.asList(RealSolutionType.class, ArrayRealSolutionType.class);
    private Double perturbation_;
    private Double mutationProbability_ = null;

    public UniformMutation(HashMap<String, Object> parameters) {
        super(parameters);
        if (parameters.get("probability") != null) {
            this.mutationProbability_ = (Double)parameters.get("probability");
        }
        if (parameters.get("perturbation") != null) {
            this.perturbation_ = (Double)parameters.get("perturbation");
        }
    }

    public void doMutation(double probability, Solution solution) throws JMException {
        XReal x = new XReal(solution);
        for (int var = 0; var < solution.getDecisionVariables().length; ++var) {
            if (!(PseudoRandom.randDouble() < probability)) continue;
            double rand = PseudoRandom.randDouble();
            double tmp = (rand - 0.5) * this.perturbation_;
            if ((tmp += x.getValue(var)) < x.getLowerBound(var)) {
                tmp = x.getLowerBound(var);
            } else if (tmp > x.getUpperBound(var)) {
                tmp = x.getUpperBound(var);
            }
            x.setValue(var, tmp);
        }
    }

    @Override
    public Object execute(Object object) throws JMException {
        Solution solution = (Solution)object;
        if (!VALID_TYPES.contains(solution.getType().getClass())) {
            Configuration.logger_.severe("UniformMutation.execute: the solution is not of the right type. The type should be 'Real', but " + solution.getType() + " is obtained");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
        this.doMutation(this.mutationProbability_, solution);
        return solution;
    }
}

