/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.selection;

import java.util.Comparator;
import java.util.HashMap;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.operators.selection.Selection;
import jmetal.util.PermutationUtility;
import jmetal.util.PseudoRandom;
import jmetal.util.comparators.DominanceComparator;

public class BinaryTournament2
extends Selection {
    private Comparator dominance_ = new DominanceComparator();
    private int[] a_;
    private int index_ = 0;

    public BinaryTournament2(HashMap<String, Object> parameters) {
        super(parameters);
    }

    @Override
    public Object execute(Object object) {
        SolutionSet population = (SolutionSet)object;
        if (this.index_ == 0) {
            this.a_ = new PermutationUtility().intPermutation(population.size());
        }
        Solution solution1 = population.get(this.a_[this.index_]);
        Solution solution2 = population.get(this.a_[this.index_ + 1]);
        this.index_ = (this.index_ + 2) % population.size();
        int flag = this.dominance_.compare(solution1, solution2);
        if (flag == -1) {
            return solution1;
        }
        if (flag == 1) {
            return solution2;
        }
        if (solution1.getCrowdingDistance() > solution2.getCrowdingDistance()) {
            return solution1;
        }
        if (solution2.getCrowdingDistance() > solution1.getCrowdingDistance()) {
            return solution2;
        }
        if (PseudoRandom.randDouble() < 0.5) {
            return solution1;
        }
        return solution2;
    }
}

