/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.selection;

import java.util.HashMap;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.operators.selection.Selection;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class DifferentialEvolutionSelection
extends Selection {
    public DifferentialEvolutionSelection(HashMap<String, Object> parameters) {
        super(parameters);
    }

    @Override
    public Object execute(Object object) throws JMException {
        int r3;
        int r2;
        int r1;
        Object[] parameters = (Object[])object;
        SolutionSet population = (SolutionSet)parameters[0];
        int index = (Integer)parameters[1];
        Solution[] parents = new Solution[3];
        if (population.size() < 4) {
            throw new JMException("DifferentialEvolutionSelection: the population has less than four solutions");
        }
        while ((r1 = PseudoRandom.randInt(0, population.size() - 1)) == index) {
        }
        while ((r2 = PseudoRandom.randInt(0, population.size() - 1)) == index || r2 == r1) {
        }
        while ((r3 = PseudoRandom.randInt(0, population.size() - 1)) == index || r3 == r1 || r3 == r2) {
        }
        parents[0] = population.get(r1);
        parents[1] = population.get(r2);
        parents[2] = population.get(r3);
        return parents;
    }
}

