/*
 * Decompiled with CFR 0.152.
 */
package jmetal.operators.selection;

import java.util.HashMap;
import jmetal.core.Solution;
import jmetal.operators.selection.Selection;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;
import jmetal.util.archive.AdaptiveGridArchive;

public class PESA2Selection
extends Selection {
    public PESA2Selection(HashMap<String, Object> parameters) {
        super(parameters);
    }

    @Override
    public Object execute(Object object) throws JMException {
        try {
            int cnt;
            AdaptiveGridArchive archive = (AdaptiveGridArchive)object;
            int hypercube1 = archive.getGrid().randomOccupiedHypercube();
            int hypercube2 = archive.getGrid().randomOccupiedHypercube();
            int selected = hypercube1 != hypercube2 ? (archive.getGrid().getLocationDensity(hypercube1) < archive.getGrid().getLocationDensity(hypercube2) ? hypercube1 : (archive.getGrid().getLocationDensity(hypercube2) < archive.getGrid().getLocationDensity(hypercube1) ? hypercube2 : (PseudoRandom.randDouble() < 0.5 ? hypercube2 : hypercube1))) : hypercube1;
            int base = PseudoRandom.randInt(0, archive.size() - 1);
            for (cnt = 0; cnt < archive.size(); ++cnt) {
                Solution individual = archive.get((base + cnt) % archive.size());
                if (archive.getGrid().location(individual) != selected) {
                    continue;
                }
                return individual;
            }
            return archive.get((base + cnt) % archive.size());
        }
        catch (ClassCastException e) {
            Configuration.logger_.severe("PESA2Selection.execute: ClassCastException. Found" + object.getClass() + "Expected: AdaptativeGridArchive");
            Class<String> cls = String.class;
            String name = cls.getName();
            throw new JMException("Exception in " + name + ".execute()");
        }
    }
}

