/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;
import jmetal.util.wrapper.XReal;

public class Binh2
extends Problem {
    public Binh2(String solutionType) throws ClassNotFoundException {
        this.numberOfVariables_ = 2;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 2;
        this.problemName_ = "Binh2";
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_[0] = 0.0;
        this.lowerLimit_[1] = 0.0;
        this.upperLimit_[0] = 5.0;
        this.upperLimit_[1] = 3.0;
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        XReal vars = new XReal(solution);
        double[] fx = new double[2];
        double[] x = new double[this.numberOfVariables_];
        for (int i = 0; i < this.numberOfVariables_; ++i) {
            x[i] = vars.getValue(i);
        }
        fx[0] = 4.0 * x[0] * x[0] + 4.0 * x[1] * x[1];
        fx[1] = (x[0] - 5.0) * (x[0] - 5.0) + (x[1] - 5.0) * (x[1] - 5.0);
        solution.setObjective(0, fx[0]);
        solution.setObjective(1, fx[1]);
    }

    @Override
    public void evaluateConstraints(Solution solution) throws JMException {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double x0 = solution.getDecisionVariables()[0].getValue();
        double x1 = solution.getDecisionVariables()[1].getValue();
        constraint[0] = -1.0 * (x0 - 5.0) * (x0 - 5.0) - x1 * x1 + 25.0;
        constraint[1] = (x0 - 8.0) * (x0 - 8.0) + (x1 + 3.0) * (x1 + 3.0) - 7.7;
        double total = 0.0;
        int number = 0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            total += constraint[i];
            ++number;
        }
        solution.setOverallConstraintViolation(total);
        solution.setNumberOfViolatedConstraint(number);
    }
}

