/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.DTLZ;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class DTLZ4
extends Problem {
    public DTLZ4(String solutionType) throws ClassNotFoundException {
        this(solutionType, 12, 3);
    }

    public DTLZ4(String solutionType, Integer numberOfVariables, Integer numberOfObjectives) throws ClassNotFoundException {
        this.numberOfVariables_ = numberOfVariables;
        this.numberOfObjectives_ = numberOfObjectives;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "DTLZ4";
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = 0.0;
            this.upperLimit_[var] = 1.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        int i;
        Variable[] gen = solution.getDecisionVariables();
        double[] x = new double[this.numberOfVariables_];
        double[] f = new double[this.numberOfObjectives_];
        double alpha = 100.0;
        int k = this.numberOfVariables_ - this.numberOfObjectives_ + 1;
        for (int i2 = 0; i2 < this.numberOfVariables_; ++i2) {
            x[i2] = gen[i2].getValue();
        }
        double g = 0.0;
        for (i = this.numberOfVariables_ - k; i < this.numberOfVariables_; ++i) {
            g += (x[i] - 0.5) * (x[i] - 0.5);
        }
        for (i = 0; i < this.numberOfObjectives_; ++i) {
            f[i] = 1.0 + g;
        }
        for (i = 0; i < this.numberOfObjectives_; ++i) {
            for (int j = 0; j < this.numberOfObjectives_ - (i + 1); ++j) {
                int n = i;
                f[n] = f[n] * Math.cos(Math.pow(x[j], alpha) * 1.5707963267948966);
            }
            if (i == 0) continue;
            int aux = this.numberOfObjectives_ - (i + 1);
            int n = i;
            f[n] = f[n] * Math.sin(Math.pow(x[aux], alpha) * 1.5707963267948966);
        }
        for (i = 0; i < this.numberOfObjectives_; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

