/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.DTLZ;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class DTLZ7
extends Problem {
    public DTLZ7(String solutionType) throws ClassNotFoundException {
        this(solutionType, 22, 3);
    }

    public DTLZ7(String solutionType, Integer numberOfVariables, Integer numberOfObjectives) throws ClassNotFoundException {
        this.numberOfVariables_ = numberOfVariables;
        this.numberOfObjectives_ = numberOfObjectives;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "DTLZ7";
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = 0.0;
            this.upperLimit_[var] = 1.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        int i;
        int i2;
        Variable[] gen = solution.getDecisionVariables();
        double[] x = new double[this.numberOfVariables_];
        double[] f = new double[this.numberOfObjectives_];
        int k = this.numberOfVariables_ - this.numberOfObjectives_ + 1;
        for (int i3 = 0; i3 < this.numberOfVariables_; ++i3) {
            x[i3] = gen[i3].getValue();
        }
        double g = 0.0;
        for (i2 = this.numberOfVariables_ - k; i2 < this.numberOfVariables_; ++i2) {
            g += x[i2];
        }
        g = 1.0 + 9.0 * g / (double)k;
        for (i2 = 0; i2 < this.numberOfObjectives_ - 1; ++i2) {
            f[i2] = x[i2];
        }
        double h = 0.0;
        for (i = 0; i < this.numberOfObjectives_ - 1; ++i) {
            h += f[i] / (1.0 + g) * (1.0 + Math.sin(Math.PI * 3 * f[i]));
        }
        h = (double)this.numberOfObjectives_ - h;
        f[this.numberOfObjectives_ - 1] = (1.0 + g) * h;
        for (i = 0; i < this.numberOfObjectives_; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

