/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;
import jmetal.util.wrapper.XReal;

public class Fonseca
extends Problem {
    public Fonseca(String solutionType) throws ClassNotFoundException {
        this.numberOfVariables_ = 3;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "Fonseca";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = -4.0;
            this.upperLimit_[var] = 4.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else if (solutionType.compareTo("ArrayReal") == 0) {
            this.solutionType_ = new ArrayRealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        XReal x = new XReal(solution);
        double[] f = new double[this.numberOfObjectives_];
        double sum1 = 0.0;
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            sum1 += StrictMath.pow(x.getValue(var) - 1.0 / StrictMath.sqrt(this.numberOfVariables_), 2.0);
        }
        double exp1 = StrictMath.exp(-1.0 * sum1);
        f[0] = 1.0 - exp1;
        double sum2 = 0.0;
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            sum2 += StrictMath.pow(x.getValue(var) + 1.0 / StrictMath.sqrt(this.numberOfVariables_), 2.0);
        }
        double exp2 = StrictMath.exp(-1.0 * sum2);
        f[1] = 1.0 - exp2;
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }
}

