/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;
import jmetal.util.wrapper.XReal;

public class FourBarTruss
extends Problem {
    double F_ = 10.0;
    double E_ = 200000.0;
    double L_ = 200.0;
    double sigma_ = 10.0;

    public FourBarTruss(String solutionType) throws ClassNotFoundException {
        this.numberOfVariables_ = 4;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "FourBarTruss";
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_[0] = this.F_ / this.sigma_;
        this.lowerLimit_[1] = Math.sqrt(2.0) * (this.F_ / this.sigma_);
        this.lowerLimit_[2] = this.lowerLimit_[1];
        this.lowerLimit_[3] = this.lowerLimit_[0];
        this.upperLimit_[0] = 3.0 * (this.F_ / this.sigma_);
        this.upperLimit_[1] = this.upperLimit_[0];
        this.upperLimit_[2] = this.upperLimit_[0];
        this.upperLimit_[3] = this.upperLimit_[0];
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        XReal vars = new XReal(solution);
        double[] fx = new double[2];
        double[] x = new double[this.numberOfVariables_];
        for (int i = 0; i < this.numberOfVariables_; ++i) {
            x[i] = vars.getValue(i);
        }
        fx[0] = this.L_ * (2.0 * x[0] + Math.sqrt(2.0) * x[1] + Math.sqrt(x[2]) + x[3]);
        fx[1] = this.F_ * this.L_ / this.E_ * (2.0 / x[0] + 2.0 * Math.sqrt(2.0) / x[1] - 2.0 * Math.sqrt(2.0) / x[2] + 2.0 / x[3]);
        solution.setObjective(0, fx[0]);
        solution.setObjective(1, fx[1]);
    }
}

