/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class Golinski
extends Problem {
    public static final double[] LOWERLIMIT = new double[]{2.6, 0.7, 17.0, 7.3, 7.3, 2.9, 5.0};
    public static final double[] UPPERLIMIT = new double[]{3.6, 0.8, 28.0, 8.3, 8.3, 3.9, 5.5};

    public Golinski(String solutionType) throws ClassNotFoundException {
        this.numberOfVariables_ = 7;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 11;
        this.problemName_ = "Golinski";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = LOWERLIMIT[var];
            this.upperLimit_[var] = UPPERLIMIT[var];
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        double x1 = solution.getDecisionVariables()[0].getValue();
        double x2 = solution.getDecisionVariables()[1].getValue();
        double x3 = solution.getDecisionVariables()[2].getValue();
        double x4 = solution.getDecisionVariables()[3].getValue();
        double x5 = solution.getDecisionVariables()[4].getValue();
        double x6 = solution.getDecisionVariables()[5].getValue();
        double x7 = solution.getDecisionVariables()[6].getValue();
        double f1 = 0.7854 * x1 * x2 * x2 * (10.0 * x3 * x3 / 3.0 + 14.933 * x3 - 43.0934) - 1.508 * x1 * (x6 * x6 + x7 * x7) + 7.477 * (x6 * x6 * x6 + x7 * x7 * x7) + 0.7854 * (x4 * x6 * x6 + x5 * x7 * x7);
        double aux = 745.0 * x4 / (x2 * x3);
        double f2 = Math.sqrt(aux * aux + 1.69E7) / (0.1 * x6 * x6 * x6);
        solution.setObjective(0, f1);
        solution.setObjective(1, f2);
    }

    @Override
    public void evaluateConstraints(Solution solution) throws JMException {
        double[] constraint = new double[this.numberOfConstraints_];
        double x1 = solution.getDecisionVariables()[0].getValue();
        double x2 = solution.getDecisionVariables()[1].getValue();
        double x3 = solution.getDecisionVariables()[2].getValue();
        double x4 = solution.getDecisionVariables()[3].getValue();
        double x5 = solution.getDecisionVariables()[4].getValue();
        double x6 = solution.getDecisionVariables()[5].getValue();
        double x7 = solution.getDecisionVariables()[6].getValue();
        constraint[0] = -(1.0 / (x1 * x2 * x2 * x3) - 0.037037037037037035);
        constraint[1] = -(1.0 / (x1 * x2 * x2 * x3 * x3) - 0.0025157232704402514);
        constraint[2] = -(x4 * x4 * x4 / (x2 * x3 * x3 * x6 * x6 * x6 * x6) - 0.5181347150259068);
        constraint[3] = -(x5 * x5 * x5 / (x2 * x3 * x7 * x7 * x7 * x7) - 0.5181347150259068);
        constraint[4] = -(x2 * x3 - 40.0);
        constraint[5] = -(x1 / x2 - 12.0);
        constraint[6] = -(5.0 - x1 / x2);
        constraint[7] = -(1.9 - x4 + 1.5 * x6);
        constraint[8] = -(1.9 - x5 + 1.1 * x7);
        double aux = 745.0 * x4 / (x2 * x3);
        double f2 = Math.sqrt(aux * aux + 1.69E7) / (0.1 * x6 * x6 * x6);
        constraint[9] = -(f2 - 1300.0);
        double a = 745.0 * x5 / (x2 * x3);
        double b = 1.575E8;
        constraint[10] = -(Math.sqrt(a * a + b) / (0.1 * x7 * x7 * x7) - 1100.0);
        double total = 0.0;
        int number = 0;
        for (int i = 0; i < this.numberOfConstraints_; ++i) {
            if (!(constraint[i] < 0.0)) continue;
            total += constraint[i];
            ++number;
        }
        solution.setOverallConstraintViolation(total);
        solution.setNumberOfViolatedConstraint(number);
    }
}

