/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.IntRealSolutionType;
import jmetal.util.JMException;

public class IntRealProblem
extends Problem {
    int intVariables_;
    int realVariables_;

    public IntRealProblem(String solutionType) throws ClassNotFoundException {
        this(solutionType, 3, 3);
    }

    public IntRealProblem(String solutionType, int intVariables, int realVariables) throws ClassNotFoundException {
        int i;
        this.intVariables_ = intVariables;
        this.realVariables_ = realVariables;
        this.numberOfVariables_ = this.intVariables_ + this.realVariables_;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "IntRealProblem";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (i = 0; i < intVariables; ++i) {
            this.lowerLimit_[i] = -5.0;
            this.upperLimit_[i] = 5.0;
        }
        for (i = intVariables; i < intVariables + realVariables; ++i) {
            this.lowerLimit_[i] = -5.0;
            this.upperLimit_[i] = 5.0;
        }
        if (solutionType.compareTo("IntReal") == 0) {
            this.solutionType_ = new IntRealSolutionType(this, intVariables, realVariables);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        int var;
        Variable[] variable = solution.getDecisionVariables();
        double[] fx = new double[2];
        fx[0] = 0.0;
        for (var = 0; var < this.intVariables_; ++var) {
            fx[0] = fx[0] + (double)((int)variable[var].getValue());
        }
        fx[1] = 0.0;
        for (var = this.intVariables_; var < this.numberOfVariables_; ++var) {
            fx[1] = fx[1] + variable[var].getValue();
        }
        solution.setObjective(0, fx[0]);
        solution.setObjective(1, fx[1]);
    }
}

