/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.LZ09;

import java.util.Vector;

public class LZ09 {
    int nvar;
    int nobj;
    int ltype;
    int dtype;
    int ptype;

    public LZ09(int nvar, int nobj, int ptype, int dtype, int ltype) {
        this.nvar = nvar;
        this.nobj = nobj;
        this.ltype = ltype;
        this.dtype = dtype;
        this.ptype = ptype;
    }

    void alphaFunction(double[] alpha, Vector<Double> x, int dim, int type) {
        if (dim == 2) {
            if (type == 21) {
                alpha[0] = x.elementAt(0);
                alpha[1] = 1.0 - Math.sqrt(x.elementAt(0));
            }
            if (type == 22) {
                alpha[0] = x.elementAt(0);
                alpha[1] = 1.0 - x.elementAt(0) * x.elementAt(0);
            }
            if (type == 23) {
                alpha[0] = x.elementAt(0);
                alpha[1] = 1.0 - Math.sqrt(alpha[0]) - alpha[0] * Math.sin(10.0 * alpha[0] * alpha[0] * Math.PI);
            }
            if (type == 24) {
                alpha[0] = x.elementAt(0);
                alpha[1] = 1.0 - x.elementAt(0) - 0.05 * Math.sin(Math.PI * 4 * x.elementAt(0));
            }
        } else {
            if (type == 31) {
                alpha[0] = Math.cos(x.elementAt(0) * Math.PI / 2.0) * Math.cos(x.elementAt(1) * Math.PI / 2.0);
                alpha[1] = Math.cos(x.elementAt(0) * Math.PI / 2.0) * Math.sin(x.elementAt(1) * Math.PI / 2.0);
                alpha[2] = Math.sin(x.elementAt(0) * Math.PI / 2.0);
            }
            if (type == 32) {
                alpha[0] = 1.0 - Math.cos(x.elementAt(0) * Math.PI / 2.0) * Math.cos(x.elementAt(1) * Math.PI / 2.0);
                alpha[1] = 1.0 - Math.cos(x.elementAt(0) * Math.PI / 2.0) * Math.sin(x.elementAt(1) * Math.PI / 2.0);
                alpha[2] = 1.0 - Math.sin(x.elementAt(0) * Math.PI / 2.0);
            }
            if (type == 33) {
                alpha[0] = x.elementAt(0);
                alpha[1] = x.elementAt(1);
                alpha[2] = 3.0 - (Math.sin(Math.PI * 3 * x.elementAt(0)) + Math.sin(Math.PI * 3 * x.elementAt(1))) - 2.0 * (x.elementAt(0) + x.elementAt(1));
            }
            if (type == 34) {
                alpha[0] = x.elementAt(0) * x.elementAt(1);
                alpha[1] = x.elementAt(0) * (1.0 - x.elementAt(1));
                alpha[2] = 1.0 - x.elementAt(0);
            }
        }
    }

    double betaFunction(Vector<Double> x, int type) {
        int i;
        double beta = 0.0;
        int dim = x.size();
        if (dim == 0) {
            beta = 0.0;
        }
        if (type == 1) {
            beta = 0.0;
            for (i = 0; i < dim; ++i) {
                beta += x.elementAt(i) * x.elementAt(i);
            }
            beta = 2.0 * beta / (double)dim;
        }
        if (type == 2) {
            beta = 0.0;
            for (i = 0; i < dim; ++i) {
                beta += Math.sqrt(i + 1) * x.elementAt(i) * x.elementAt(i);
            }
            beta = 2.0 * beta / (double)dim;
        }
        if (type == 3) {
            double sum = 0.0;
            for (int i2 = 0; i2 < dim; ++i2) {
                double xx = 2.0 * x.elementAt(i2);
                sum += xx * xx - Math.cos(Math.PI * 4 * xx) + 1.0;
            }
            beta = 2.0 * sum / (double)dim;
        }
        if (type == 4) {
            double sum = 0.0;
            double prod = 1.0;
            for (int i3 = 0; i3 < dim; ++i3) {
                double xx = 2.0 * x.elementAt(i3);
                sum += xx * xx;
                prod *= Math.cos(Math.PI * 10 * xx / Math.sqrt(i3 + 1));
            }
            beta = 2.0 * (sum - 2.0 * prod + 2.0) / (double)dim;
        }
        return beta;
    }

    double psfunc2(double x, double t1, int dim, int type, int css) {
        double xy;
        double ra;
        double xy2;
        double theta;
        double beta = 0.0;
        ++dim;
        if (type == 21) {
            double xy3 = 2.0 * (x - 0.5);
            beta = xy3 - Math.pow(t1, 0.5 * (double)(this.nvar + 3 * dim - 8) / (double)(this.nvar - 2));
        }
        if (type == 22) {
            theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.nvar;
            xy2 = 2.0 * (x - 0.5);
            beta = xy2 - Math.sin(theta);
        }
        if (type == 23) {
            theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.nvar;
            ra = 0.8 * t1;
            xy = 2.0 * (x - 0.5);
            beta = css == 1 ? xy - ra * Math.cos(theta) : xy - ra * Math.sin(theta);
        }
        if (type == 24) {
            theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.nvar;
            xy2 = 2.0 * (x - 0.5);
            double ra2 = 0.8 * t1;
            beta = css == 1 ? xy2 - ra2 * Math.cos(theta / 3.0) : xy2 - ra2 * Math.sin(theta);
        }
        if (type == 25) {
            double rho = 0.8;
            double phi = Math.PI * t1;
            double theta2 = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.nvar;
            double xy4 = 2.0 * (x - 0.5);
            beta = css == 1 ? xy4 - rho * Math.sin(phi) * Math.sin(theta2) : (css == 2 ? xy4 - rho * Math.sin(phi) * Math.cos(theta2) : xy4 - rho * Math.cos(phi));
        }
        if (type == 26) {
            theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.nvar;
            ra = 0.3 * t1 * (t1 * Math.cos(4.0 * theta) + 2.0);
            xy = 2.0 * (x - 0.5);
            beta = css == 1 ? xy - ra * Math.cos(theta) : xy - ra * Math.sin(theta);
        }
        return beta;
    }

    double psfunc3(double x, double t1, double t2, int dim, int type) {
        double beta = 0.0;
        ++dim;
        if (type == 31) {
            double xy = 4.0 * (x - 0.5);
            double rate = 1.0 * (double)dim / (double)this.nvar;
            beta = xy - 4.0 * (t1 * t1 * rate + t2 * (1.0 - rate)) + 2.0;
        }
        if (type == 32) {
            double theta = Math.PI * 2 * t1 + (double)dim * Math.PI / (double)this.nvar;
            double xy = 4.0 * (x - 0.5);
            beta = xy - 2.0 * t2 * Math.sin(theta);
        }
        return beta;
    }

    void objective(Vector<Double> x_var, Vector<Double> y_obj) {
        Vector<Double> bb;
        Vector<Double> aa;
        double h;
        double g;
        if (this.nobj == 2) {
            double b;
            double a;
            if (this.ltype == 21 || this.ltype == 22 || this.ltype == 23 || this.ltype == 24 || this.ltype == 26) {
                g = 0.0;
                h = 0.0;
                aa = new Vector<Double>();
                bb = new Vector<Double>();
                for (int n = 1; n < this.nvar; ++n) {
                    if (n % 2 == 0) {
                        a = this.psfunc2(x_var.elementAt(n), x_var.elementAt(0), n, this.ltype, 1);
                        aa.addElement(a);
                        continue;
                    }
                    b = this.psfunc2(x_var.elementAt(n), x_var.elementAt(0), n, this.ltype, 2);
                    bb.addElement(b);
                }
                g = this.betaFunction(aa, this.dtype);
                h = this.betaFunction(bb, this.dtype);
                double[] alpha = new double[2];
                this.alphaFunction(alpha, x_var, 2, this.ptype);
                y_obj.set(0, alpha[0] + h);
                y_obj.set(1, alpha[1] + g);
                aa.clear();
                bb.clear();
            }
            if (this.ltype == 25) {
                g = 0.0;
                h = 0.0;
                double e = 0.0;
                Vector<Double> aa2 = new Vector<Double>();
                Vector<Double> bb2 = new Vector<Double>();
                for (int n = 1; n < this.nvar; ++n) {
                    if (n % 3 == 0) {
                        a = this.psfunc2(x_var.elementAt(n), x_var.elementAt(0), n, this.ltype, 1);
                        aa2.addElement(a);
                        continue;
                    }
                    if (n % 3 == 1) {
                        b = this.psfunc2(x_var.elementAt(n), x_var.elementAt(0), n, this.ltype, 2);
                        bb2.addElement(b);
                        continue;
                    }
                    double c = this.psfunc2(x_var.elementAt(n), x_var.elementAt(0), n, this.ltype, 3);
                    if (n % 2 == 0) {
                        aa2.addElement(c);
                        continue;
                    }
                    bb2.addElement(c);
                }
                g = this.betaFunction(aa2, this.dtype);
                h = this.betaFunction(bb2, this.dtype);
                double[] alpha = new double[2];
                this.alphaFunction(alpha, x_var, 2, this.ptype);
                y_obj.set(0, alpha[0] + h);
                y_obj.set(1, alpha[1] + g);
                aa2.clear();
                bb2.clear();
            }
        }
        if (this.nobj == 3 && (this.ltype == 31 || this.ltype == 32)) {
            g = 0.0;
            h = 0.0;
            double e = 0.0;
            aa = new Vector();
            bb = new Vector();
            Vector<Double> cc = new Vector<Double>();
            for (int n = 2; n < this.nvar; ++n) {
                double a = this.psfunc3(x_var.elementAt(n), x_var.elementAt(0), x_var.elementAt(1), n, this.ltype);
                if (n % 3 == 0) {
                    aa.addElement(a);
                    continue;
                }
                if (n % 3 == 1) {
                    bb.addElement(a);
                    continue;
                }
                cc.addElement(a);
            }
            g = this.betaFunction(aa, this.dtype);
            h = this.betaFunction(bb, this.dtype);
            e = this.betaFunction(cc, this.dtype);
            double[] alpha = new double[3];
            this.alphaFunction(alpha, x_var, 3, this.ptype);
            y_obj.set(0, alpha[0] + h);
            y_obj.set(1, alpha[1] + g);
            y_obj.set(2, alpha[2] + e);
            aa.clear();
            bb.clear();
            cc.clear();
        }
    }
}

