/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.PermutationSolutionType;
import jmetal.encodings.variable.Permutation;

public class MOTSP
extends Problem {
    public int numberOfCities_;
    public double[][] distanceMatrix_;
    public double[][] costMatrix_;

    public MOTSP(String solutionType, String file_distances, String file_cost) throws FileNotFoundException, IOException, ClassNotFoundException {
        this.numberOfVariables_ = 1;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "MOTSP";
        this.length_ = new int[this.numberOfVariables_];
        this.distanceMatrix_ = this.readProblem(file_distances);
        this.costMatrix_ = this.readProblem(file_cost);
        System.out.println(this.numberOfCities_);
        this.length_[0] = this.numberOfCities_;
        if (solutionType.compareTo("Permutation") == 0) {
            this.solutionType_ = new PermutationSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) {
        double fitness1 = 0.0;
        double fitness2 = 0.0;
        for (int i = 0; i < this.numberOfCities_ - 1; ++i) {
            int x = ((Permutation)solution.getDecisionVariables()[0]).vector_[i];
            int y = ((Permutation)solution.getDecisionVariables()[0]).vector_[i + 1];
            fitness1 += this.distanceMatrix_[x][y];
            fitness2 += this.costMatrix_[x][y];
        }
        int firstCity = ((Permutation)solution.getDecisionVariables()[0]).vector_[0];
        int lastCity = ((Permutation)solution.getDecisionVariables()[0]).vector_[this.numberOfCities_ - 1];
        solution.setObjective(0, fitness1 += this.distanceMatrix_[firstCity][lastCity]);
        solution.setObjective(1, fitness2 += this.costMatrix_[firstCity][lastCity]);
    }

    public double[][] readProblem(String file) throws FileNotFoundException, IOException {
        double[][] matrix = null;
        BufferedReader inputFile = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        StreamTokenizer token = new StreamTokenizer(inputFile);
        try {
            boolean found = false;
            token.nextToken();
            while (!found) {
                if (token.sval != null && token.sval.compareTo("DIMENSION") == 0) {
                    found = true;
                    continue;
                }
                token.nextToken();
            }
            token.nextToken();
            token.nextToken();
            this.numberOfCities_ = (int)token.nval;
            matrix = new double[this.numberOfCities_][this.numberOfCities_];
            found = false;
            token.nextToken();
            while (!found) {
                if (token.sval != null && token.sval.compareTo("SECTION") == 0) {
                    found = true;
                    continue;
                }
                token.nextToken();
            }
            double[] c = new double[2 * this.numberOfCities_];
            for (int i = 0; i < this.numberOfCities_; ++i) {
                token.nextToken();
                int j = (int)token.nval;
                token.nextToken();
                c[2 * (j - 1)] = token.nval;
                token.nextToken();
                c[2 * (j - 1) + 1] = token.nval;
            }
            for (int k = 0; k < this.numberOfCities_; ++k) {
                matrix[k][k] = 0.0;
                for (int j = k + 1; j < this.numberOfCities_; ++j) {
                    double dist = Math.sqrt(Math.pow(c[k * 2] - c[j * 2], 2.0) + Math.pow(c[k * 2 + 1] - c[j * 2 + 1], 2.0));
                    matrix[k][j] = dist = (double)((int)(dist + 0.5));
                    matrix[j][k] = dist;
                }
            }
        }
        catch (Exception e) {
            System.err.println("TSP.readProblem(): error when reading data file " + e);
            System.exit(1);
        }
        return matrix;
    }
}

