/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class OKA2
extends Problem {
    public OKA2(String solutionType) throws ClassNotFoundException {
        this.numberOfVariables_ = 3;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "OKA2";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_[0] = -Math.PI;
        this.upperLimit_[0] = Math.PI;
        for (int i = 1; i < this.numberOfVariables_; ++i) {
            this.lowerLimit_[i] = -5.0;
            this.upperLimit_[i] = 5.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        Variable[] decisionVariables = solution.getDecisionVariables();
        double[] fx = new double[this.numberOfObjectives_];
        double[] x = new double[this.numberOfVariables_];
        for (int i = 0; i < this.numberOfVariables_; ++i) {
            x[i] = decisionVariables[i].getValue();
        }
        fx[0] = x[0];
        fx[1] = 1.0 - Math.pow(x[0] + Math.PI, 2.0) / (4.0 * Math.pow(Math.PI, 2.0)) + Math.pow(Math.abs(x[1] - 5.0 * Math.cos(x[0])), 0.3333333333333333) + Math.pow(Math.abs(x[2] - 5.0 * Math.sin(x[0])), 0.3333333333333333);
        solution.setObjective(0, fx[0]);
        solution.setObjective(1, fx[1]);
    }
}

